#include "mbed.h"
#include "Si7020.h"
#include "LPS25H.h"
#include "LSM303D.h"

DigitalOut myled(LED1);

Serial pc(SERIAL_TX, SERIAL_RX); //serial debug output, 9600 bps 8 bit, no parity 1 stop bit no flow control.

//I2C declarations
I2C       i2c(PB_9,PB_8);   // SDA, SCL
I2CSlave  slave(PB_3,PB_10);   // SDA, SCL
Si7020 si(&i2c);
LPS25H baro(&i2c, LPS25H_G_CHIP_ADDR);

AnalogIn adc(ADC_TEMP);

LSM303D lsm303d_1(&i2c);
static float magx,magy,magz,accx,accy,accz;
//static LSM303D::raw_data accxx,accyy,acczz,magxx,magyy,magzz;
//static LSM303D::vector<LSM303D::raw_data> a,m;

//int I2C_ADDR = 0x00200; 
static const char I2C_ADDR =  0xE5 ;
int main() {
    
    //i2c setups
    i2c.frequency(100000); //Set the clock frequency
    slave.frequency(100000); //Set the clock frequency
    slave.address(I2C_ADDR);
    

    pc.printf("Hello world! Cosmic Pi STM32F401RE Test program\n");
    while(1) {
    pc.printf("This is a loop\n");
    //flash the power LED
        myled = 1; // LED is ON
        wait(0.2); // 200 ms
        myled = 0; // LED is OFF
        wait(1.0); // 1 sec
        
    //STM32 internal temp sensor
    float tempuc = adc.read()*100;
    pc.printf("Internal Temp Sensor (ADC) = %.1f\r\n", tempuc);
    
    //Si7006 readout, temperature and humidity
    float humid;
        if(si.getHumidity(&humid) != 0) {
            printf("Error getting humidity\n");
            humid = -1;
        }

        float temp;
        if(si.getTemperature(&temp) != 0) {
            printf("Error getting temperature");
            temp = -1;
        } 
        printf("Si7006 readout - Humidity = %f%% Temperature = %fC\n", humid, temp);

    //LPS25H readout
     baro.get();
      printf("LPH25S readout: Pressure: %.1f, Temperature: %.1f\r\n",
              baro.pressure(), baro.temperature());

    //LSM303D readout (accel + mag)
if (lsm303d_1.read(&accx,&accy,&accz,&magx,&magy,&magz) !=0) {
             printf("Error getting LSM303D values\n");
        }
 
       printf("LSM303D mag readout x: %f y: %f z: %f\n\r",magx,magy,magz);
       printf("LSM303D acc readout x: %f y: %f z: %f\n\r",accx,accy,accz);
             

        wait(1);
    }
}




