#include "mbed.h"
#include "ssd1331.h"
#include "DHT.h"
#include "gy-906.h"

//PwmOut motorAir(PA_0);
//PwmOut motorFan(PB_0);
PwmOut motorAir(PA_0);
PwmOut motorFan(PB_0);
using namespace gy906;
ssd1331 status(PB_1, PB_6, PB_14, PB_5, NC, PB_3); // cs, res, dc, miso(nc), sck (KL25z)
ssd1331 oled(PC_8, PC_6, PC_5, PB_15, NC, PB_13); // cs, res, dc, miso(nc), sck (KL25z)
DHT airTemp(D2, DHT22); // Use the SEN11301P sensor
I2C kettleTemp(D14, D15);   //sda,scl
Serial pc(D1, D0);
Serial bt(PA_15, PB_7);
Timer tt, minn;
float temp;
float temp1, temp2;


const uint8_t addr = default_addr;
float get_temp(uint8_t reg) {
    char cmd[3] = { 0 };
    cmd[0] = opcode::ram_access | reg;
    kettleTemp.write(addr,cmd,1,true); kettleTemp.read(addr,cmd,3);
    return (0.02 * static_cast<float>((cmd[1]<<8)|cmd[0])) - 273.15;
}
void fanW(){
    oled.cls();
    oled.pixel(40, 62, 0xFFFF); oled.Copy(40, 62, 40, 62, 41, 62);  oled.Copy(40, 62, 41, 62, 42, 62);  oled.Copy(40, 62, 43, 62, 44, 62);
    oled.Copy(40, 62, 46, 62, 48, 62);  oled.Copy(40, 62, 53, 62, 41, 1);   oled.Copy(40, 62, 41, 62, 40, 2);   oled.Copy(40, 62, 42, 62, 38, 3);
    oled.Copy(38, 2, 41, 3, 35, 4);   oled.Copy(39, 1, 42, 3, 32, 6);   oled.Copy(41, 1, 42, 2, 31, 9); oled.Copy(40, 1, 41, 3, 30, 11);
    oled.Copy(30, 9, 32, 13, 28, 14);   oled.Copy(29, 14, 29, 17, 28, 19);  oled.Copy(28, 17, 28, 22, 28, 23);  oled.Copy(28, 17, 28, 20, 29, 28);
    oled.Copy(28, 17, 28, 20, 30, 31);  oled.Copy(40, 62, 41, 62, 54, 2);   oled.Copy(40, 62, 42, 62, 55, 3);   oled.Copy(54, 2, 57, 3, 57, 4);
    oled.Copy(53, 1, 55, 2, 60, 6); oled.Copy(54, 1, 55, 3, 62, 8);    oled.Copy(62, 7, 63, 10, 64, 10);   oled.Copy(63, 10, 64, 12, 65, 14);
    oled.Copy(63, 10, 64, 12, 66, 17);  oled.Copy(60, 5, 62, 8, 31, 34);    oled.Copy(59, 5, 62, 7, 33, 38);    oled.Copy(54, 2, 57, 3, 36, 41);
    oled.Copy(55, 2, 57, 3, 40, 42);    oled.Copy(55, 3, 57, 3, 42, 44);    oled.Copy(28, 17, 28, 25, 67, 20);  oled.Copy(28, 17, 28, 20, 66, 28);
    oled.Copy(29, 12, 30, 17, 64, 31);  oled.Copy(33, 5, 35, 8, 61, 36);    oled.Copy(33, 5, 35, 8, 58, 39);    oled.Copy(40, 62, 42, 62, 55, 42);
    oled.Copy(40, 62, 42, 62, 53, 43);  oled.Copy(40, 62, 42, 62, 51, 44);  oled.Copy(28, 17, 28, 23, 44, 45);  oled.Copy(28, 17, 28, 23, 51, 45);
    oled.Copy(38, 2, 41, 3, 40, 51);    oled.Copy(38, 2, 41, 3, 36, 52);    oled.Copy(28, 17, 29, 21, 35, 54);  oled.Copy(35, 40, 40, 42, 35, 59);
    oled.Copy(36, 41, 40, 42, 52, 51);  oled.Copy(52, 1, 55, 2, 56, 53);    oled.Copy(66, 24, 67, 29, 58, 55);  oled.Copy(55, 41, 58, 42, 54, 60);
}
void airW(){
    oled.cls();
    oled.line(14, 1, 81, 1, 0xFFFF);
    oled.Copy(14, 1, 14, 1, 13, 2); oled.Copy(13, 2, 13, 2, 14, 2); oled.Copy(13, 2, 14, 2, 12, 3); oled.Copy(13, 2, 14, 2, 11, 4);
    oled.Copy(13, 2, 14, 2, 81, 2); oled.Copy(13, 2, 14, 2, 82, 3); oled.Copy(13, 2, 14, 2, 83, 4); oled.Copy(12, 3, 12, 4, 11, 5);
    oled.Copy(11, 5, 11, 6, 11, 7); oled.Copy(11, 5, 11, 8, 11, 9); oled.Copy(11, 5, 11, 12, 11, 13);   oled.Copy(11, 5, 11, 13, 11, 21);
    oled.Copy(11, 5, 11, 29, 84, 5);    oled.Copy(81, 1, 83, 3, 12, 29);    oled.Copy(12, 1, 14, 3, 81, 29);    oled.Copy(14, 1, 81, 1, 14, 32);
    oled.Copy(14, 1, 17, 1, 28, 37);    oled.Copy(13, 2, 13, 2, 28, 38);    oled.Copy(13, 2, 13, 2, 31, 38);    oled.Copy(28, 38, 31, 38, 28, 39);
    oled.Copy(13, 2, 13, 2, 27, 40);    oled.Copy(28, 38, 31, 38, 28, 40);  oled.Copy(28, 38, 31, 39, 27, 41);  oled.Copy(13, 2, 13, 2, 31, 41);
    oled.Copy(27, 40, 31, 42, 26, 43);  oled.Copy(28, 38, 31, 39, 26, 46);  oled.Copy(13, 2, 13, 2, 30, 47);    oled.Copy(13, 2, 13, 2, 26, 48);
    oled.Copy(28, 38, 31, 39, 27, 48);  oled.Copy(26, 47, 30, 49, 27, 50);  oled.Copy(27, 38, 31, 41, 27, 53);  oled.Copy(27, 40, 31, 43, 26, 57);
    oled.Copy(28, 38, 31, 38, 26, 61);  oled.Copy(28, 37, 31, 37, 26, 62);  oled.Copy(26, 37, 31, 62, 45, 37);  oled.Copy(26, 37, 31, 62, 64, 37);
}
void kettleW(){
    oled.cls();
    oled.pixel(19, 62, 0xFFFF); oled.Copy(19, 62, 19, 62, 20, 62);  oled.Copy(19, 62, 20, 62, 21, 62);  oled.Copy(19, 62, 22, 62, 23, 62);
    oled.Copy(19, 62, 26, 62, 27, 62);  oled.Copy(19, 62, 34, 62, 35, 62);  oled.Copy(19, 62, 37, 62, 51, 62);  oled.Copy(19, 62, 27, 62, 40, 1);
    oled.Copy(19, 62, 21, 62, 38, 2);   oled.Copy(19, 62, 22, 62, 48, 2);   oled.Copy(19, 62, 21, 62, 36, 3);   oled.Copy(19, 62, 21, 62, 51, 3);
    oled.Copy(19, 62, 21, 62, 34, 4);   oled.Copy(19, 62, 21, 62, 53, 4);   oled.Copy(19, 62, 26, 62, 22, 11);  oled.Copy(19, 62, 34, 62, 60, 11);
    oled.Copy(19, 62, 27, 62, 63, 19);  oled.Copy(19, 62, 21, 62, 38, 2);   oled.Copy(19, 62, 21, 62, 19, 50);  oled.Copy(19, 62, 20, 62, 18, 61);
    oled.Copy(19, 62, 20, 62, 17, 60);  oled.Copy(19, 62, 20, 62, 16, 59);  oled.Copy(19, 61, 19, 62, 16, 57);  oled.Copy(16, 57, 16, 59, 16, 54);
    oled.Copy(19, 62, 20, 62, 16, 53);  oled.Copy(19, 62, 20, 62, 17, 52);  oled.Copy(19, 62, 20, 62, 18, 51);  oled.Copy(16, 53, 16, 59, 21, 36);
    oled.Copy(16, 53, 16, 59, 21, 43);  oled.Copy(21, 36, 21, 41, 22, 31);  oled.Copy(21, 36, 21, 44, 23, 23);  oled.Copy(21, 36, 21, 39, 24, 20);
    oled.Copy(16, 59, 19, 62, 20, 17);  oled.Copy(16, 52, 18, 56, 20, 12);  oled.Copy(16, 50, 19, 53, 29, 7);   oled.Copy(16, 52, 18, 53, 32, 5);
    oled.Copy(17, 50, 20, 52, 69, 59);  oled.Copy(16, 53, 16, 58, 72, 53);  oled.Copy(17, 59, 20, 62, 69, 49);  oled.Copy(21, 36, 21, 50, 68, 35);
    oled.Copy(69, 59, 72, 62, 69, 32);  oled.Copy(69, 59, 72, 61, 72, 29);  oled.Copy(70, 59, 71, 61, 75, 26);  oled.Copy(70, 59, 71, 61, 76, 23);
    oled.Copy(21, 36, 21, 45, 78, 14);  oled.Copy(69, 50, 71, 52, 75, 12);  oled.Copy(16, 57, 18, 60, 58, 7);   oled.Copy(69, 50, 71, 52, 55, 5);
    oled.Copy(16, 52, 17, 55, 69, 20);  oled.Copy(70, 57, 72, 61, 66, 23);  oled.Copy(21, 36, 21, 41, 65, 23);  oled.Copy(71, 52, 72, 55, 63, 20);
}
void tvW(){
    oled.cls();
    oled.pixel(30, 2, 0xFFFF);  oled.Copy(30, 2, 30, 2, 31, 2); oled.Copy(30, 2, 31, 2, 32, 2); oled.Copy(30, 2, 33, 2, 48, 2);
    oled.Copy(30, 2, 30, 2, 30, 3); oled.Copy(30, 2, 31, 2, 33, 3); oled.Copy(30, 2, 31, 2, 47, 3); oled.Copy(30, 2, 30, 2, 51, 3);
    oled.Copy(30, 2, 30, 2, 30, 4); oled.Copy(30, 3, 34, 3, 31, 4); oled.Copy(47, 3, 51, 3, 46, 4); oled.Copy(30, 2, 30, 2, 51, 4);
    oled.Copy(30, 2, 30, 2, 31, 5); oled.Copy(30, 3, 35, 4, 32, 5); oled.Copy(46, 3, 51, 4, 44, 5); oled.Copy(30, 2, 30, 2, 50, 5);
    oled.Copy(30, 2, 30, 2, 33, 7); oled.Copy(30, 3, 37, 6, 34, 7); oled.Copy(45, 3, 51, 5, 41, 7); oled.Copy(30, 2, 30, 2, 48, 7);
    oled.Copy(46, 2, 49, 4, 29, 10);    oled.Copy(30, 2, 32, 2, 33, 10);    oled.Copy(31, 10, 35, 10, 44, 10);  oled.Copy(32, 2, 35, 4, 49, 10);
    oled.Copy(30, 2, 30, 2, 29, 13);    oled.Copy(30, 2, 30, 2, 52, 13);    oled.Copy(31, 10, 37, 10, 16, 14);  oled.Copy(31, 10, 37, 10, 23, 14);
    oled.Copy(32, 13, 49, 13, 30, 14);  oled.Copy(32, 13, 35, 13, 48, 14);  oled.Copy(16, 14, 29, 14, 52, 14);  oled.Copy(16, 14, 29, 14, 66, 14);
    oled.Copy(30, 2, 30, 4, 16, 15);    oled.Copy(16, 14, 16, 17, 16, 18);  oled.Copy(16, 14, 16, 21, 16, 22);  oled.Copy(16, 14, 16, 29, 16, 30);
    oled.Copy(16, 14, 16, 26, 16, 46);  oled.Copy(16, 15, 16, 58, 79, 15);  oled.Copy(31, 10, 35, 10, 17, 58);  oled.Copy(52, 14, 79, 14, 29, 58);
    oled.Copy(52, 14, 61, 14, 57, 58);  oled.Copy(31, 10, 35, 10, 74, 58);  oled.Copy(30, 2, 30, 4, 20, 59);    oled.Copy(30, 2, 30, 4, 30, 59);
    oled.Copy(30, 2, 30, 4, 65, 59);    oled.Copy(30, 2, 30, 4, 75, 59);    oled.Copy(52, 14, 62, 14, 20, 62);  oled.Copy(52, 14, 62, 14, 65, 62);
}
void radioW(){
    oled.cls();
    oled.pixel(16, 62, 0xFFFF); oled.Copy(16, 62, 16, 62, 17, 62);  oled.Copy(16, 62, 17, 62, 18, 62);  oled.Copy(16, 62, 19, 62, 20, 62);
    oled.Copy(16, 62, 23, 62, 24, 62);  oled.Copy(16, 62, 31, 62, 32, 62);  oled.Copy(16, 62, 47, 62, 48, 62);  oled.Copy(16, 62, 23, 62, 68, 1);
    oled.Copy(16, 62, 26, 62, 40, 5);   oled.Copy(16, 62, 20, 62, 43, 8);   oled.Copy(16, 62, 19, 62, 44, 10);  oled.Copy(16, 62, 24, 62, 55, 12);
    oled.Copy(16, 62, 19, 62, 67, 12);  oled.Copy(16, 62, 19, 62, 73, 12);  oled.Copy(16, 62, 21, 62, 58, 16);  oled.Copy(16, 62, 20, 62, 38, 18);
    oled.Copy(16, 62, 20, 62, 44, 18);  oled.Copy(16, 62, 43, 62, 20, 22);  oled.Copy(16, 62, 20, 62, 66, 22);  oled.Copy(16, 62, 20, 62, 73, 22);
    oled.Copy(16, 62, 20, 62, 53, 25);  oled.Copy(16, 62, 20, 62, 16, 26);  oled.Copy(16, 62, 35, 62, 47, 26);  oled.Copy(16, 62, 18, 62, 77, 26);
    oled.Copy(16, 26, 16, 26, 16, 27);  oled.Copy(16, 26, 16, 27, 16, 28);  oled.Copy(16, 26, 16, 29, 16, 30);  oled.Copy(16, 26, 16, 33, 16, 34);
    oled.Copy(16, 26, 16, 41, 16, 42);  oled.Copy(16, 26, 16, 29, 16, 58);  oled.Copy(16, 26, 16, 28, 20, 23);  oled.Copy(16, 26, 16, 29, 33, 23);
    oled.Copy(16, 26, 16, 29, 34, 23);  oled.Copy(16, 26, 16, 30, 36, 12);  oled.Copy(16, 26, 16, 30, 40, 6);   oled.Copy(16, 26, 16, 28, 47, 23);
    oled.Copy(16, 26, 16, 36, 50, 6);   oled.Copy(16, 26, 16, 30, 51, 19);  oled.Copy(16, 26, 16, 30, 55, 13);  oled.Copy(16, 26, 16, 29, 58, 16);
    oled.Copy(16, 26, 16, 30, 59, 19);  oled.Copy(16, 26, 16, 28, 63, 13);  oled.Copy(16, 26, 16, 29, 66, 23);  oled.Copy(16, 26, 16, 32, 67, 5);
    oled.Copy(16, 26, 16, 29, 68, 2);   oled.Copy(16, 26, 16, 34, 70, 13);  oled.Copy(16, 26, 16, 34, 73, 13);  oled.Copy(16, 26, 16, 29, 75, 2);
    oled.Copy(16, 26, 16, 33, 76, 5);   oled.Copy(16, 26, 16, 28, 77, 23);  oled.Copy(16, 26, 16, 61, 79, 27);  oled.Copy(16, 26, 17, 27, 38, 10);
    oled.Copy(16, 26, 16, 27, 37, 11);  oled.Copy(37, 10, 39, 12, 52, 17);  oled.Copy(16, 61, 17, 62, 37, 16);  oled.Copy(16, 61, 17, 62, 43, 16);
    oled.Copy(16, 61, 17, 62, 52, 23);  oled.Copy(78, 61, 79, 62, 48, 16);  oled.Copy(78, 61, 79, 62, 57, 23);  oled.Copy(16, 62, 16, 62, 42, 17);
    oled.Copy(16, 27, 16, 30, 43, 9);   oled.Copy(16, 62, 16, 62, 47, 9);
}
void fanC(){
    oled.pixel(42, 4, 0xE9B1); oled.Copy(42, 4, 42, 4, 43, 4); oled.Copy(42, 4, 43, 4, 44, 4); oled.Copy(42, 4, 45, 4, 46, 4);
        oled.Copy(42, 4, 45, 4, 50, 4);     oled.Copy(42, 4, 44, 4, 40, 5); oled.Copy(40, 4, 43, 5, 37, 6); oled.Copy(39, 5, 41, 7, 35, 8);
        oled.Copy(39, 5, 40, 7, 33, 10);    oled.Copy(39, 5, 40, 7, 32, 13);    oled.Copy(33, 11, 34, 14, 31, 16);  oled.Copy(33, 11, 33, 14, 31, 20);
        oled.Copy(33, 11, 33, 14, 31, 24);  oled.Copy(42, 4, 44, 4, 53, 5); oled.Copy(52, 4, 55, 5, 55, 6); oled.Copy(52, 4, 54, 5, 58, 8);
        oled.Copy(55, 5, 56, 7, 60, 10);    oled.Copy(42, 4, 44, 4, 53, 5); oled.Copy(60, 9, 61, 12, 62, 12);   oled.Copy(59, 9, 60, 11, 63, 16);
        oled.Copy(60, 9, 60, 11, 64, 19);   oled.Copy(64, 16, 64, 21, 64, 22);  oled.Copy(63, 16, 64, 19, 31, 28);  oled.Copy(60, 9, 61, 12, 33, 31);
        oled.Copy(60, 9, 61, 12, 35, 34);   oled.Copy(58, 7, 60, 10, 37, 37);   oled.Copy(42, 4, 42, 4, 40, 39);    oled.Copy(42, 4, 45, 4, 40, 40);
        oled.Copy(42, 4, 51, 4, 43, 41);    oled.Copy(31, 16, 32, 19, 63, 28);  oled.Copy(63, 25, 64, 28, 61, 31);  oled.Copy(34, 8, 37, 10, 58, 35);
        oled.Copy(42, 4, 44, 4, 56, 38);    oled.Copy(42, 4, 44, 4, 55, 39);    oled.Copy(42, 4, 46, 4, 52, 40);
    oled.pixel(41, 8, 0xD69A);  oled.Copy(41, 8, 41, 8, 42, 8); oled.Copy(41, 8, 42, 8, 43, 8); oled.Copy(41, 8, 44, 8, 45, 8);
        oled.Copy(41, 8, 46, 8, 49, 8); oled.Copy(41, 8, 50, 8, 43, 7); oled.Copy(41, 8, 44, 8, 40, 9); oled.Copy(42, 7, 46, 8, 38, 10);
        oled.Copy(42, 7, 47, 8, 36, 12);    oled.Copy(43, 7, 49, 8, 35, 14);    oled.Copy(43, 7, 51, 8, 34, 16);    oled.Copy(44, 7, 53, 8, 34, 18);
        oled.Copy(43, 7, 48, 7, 33, 20);    oled.Copy(40, 9, 43, 10, 33, 21);   oled.Copy(43, 7, 44, 8, 33, 23);    oled.Copy(41, 15, 42, 18, 34, 25);
        oled.Copy(43, 7, 44, 8, 35, 29);    oled.Copy(34, 27, 36, 29, 36, 31);  oled.Copy(43, 7, 46, 7, 52, 9); oled.Copy(49, 7, 53, 8, 53, 10);
        oled.Copy(48, 7, 53, 8, 54, 12);    oled.Copy(46, 7, 52, 8, 54, 14);    oled.Copy(44, 7, 52, 8, 53, 16);    oled.Copy(42, 7, 51, 8, 52, 18);
        oled.Copy(43, 7, 50, 7, 55, 20);    oled.Copy(53, 11, 57, 12, 58, 21);  oled.Copy(53, 11, 55, 12, 60, 23);  oled.Copy(53, 14, 54, 17, 60, 25);
        oled.Copy(53, 15, 55, 16, 58, 29);  oled.Copy(53, 15, 55, 16, 57, 31);  oled.Copy(43, 7, 45, 7, 56, 33);    oled.Copy(43, 7, 44, 7, 47, 29);
        oled.Copy(43, 7, 46, 7, 46, 30);    oled.Copy(43, 7, 48, 8, 45, 31);    oled.Copy(43, 7, 51, 7, 43, 33);    oled.Copy(43, 7, 52, 7, 38, 34);
        oled.Copy(43, 7, 52, 7, 48, 34);    oled.Copy(38, 34, 55, 34, 39, 35);  oled.Copy(38, 34, 53, 34, 40, 36);  oled.Copy(38, 34, 49, 34, 42, 37);
        oled.Copy(38, 34, 45, 34, 44, 38);  oled.Copy(47, 29, 48, 36, 47, 44);
    oled.pixel(43, 13, 0x94B3); oled.Copy(43, 13, 43, 13, 44, 13);  oled.Copy(43, 13, 44, 13, 45, 13);  oled.Copy(43, 13, 46, 13, 47, 13);
        oled.Copy(43, 13, 44, 13, 51, 13);  oled.Copy(43, 13, 52, 13, 43, 14);  oled.Copy(43, 13, 50, 14, 44, 11);  oled.Copy(44, 11, 51, 13, 44, 15);
        oled.Copy(44, 11, 49, 11, 45, 10);  oled.Copy(44, 11, 45, 11, 45, 18);  oled.Copy(44, 11, 45, 11, 49, 18);  oled.Copy(44, 11, 45, 11, 42, 21);
        oled.Copy(44, 11, 44, 11, 52, 21);  oled.Copy(44, 11, 45, 11, 49, 18);  oled.Copy(44, 10, 49, 11, 38, 22);  oled.Copy(45, 12, 52, 14, 37, 24);
        oled.Copy(43, 14, 51, 15, 37, 27);  oled.Copy(43, 14, 49, 14, 38, 29);  oled.Copy(43, 13, 47, 14, 39, 30);  oled.Copy(43, 14, 45, 14, 52, 22);
        oled.Copy(45, 10, 51, 11, 52, 23);  oled.Copy(44, 11, 51, 12, 51, 25);  oled.Copy(44, 14, 52, 15, 50, 27);  oled.Copy(43, 14, 48, 15, 51, 29);
        oled.Copy(44, 11, 47, 11, 52, 31);
    oled.pixel(38, 55, 0xF437); oled.Copy(38, 55, 38, 55, 39, 55);  oled.Copy(38, 55, 39, 55, 40, 55);  oled.Copy(38, 55, 41, 55, 42, 55);
        oled.Copy(38, 55, 45, 55, 46, 55);  oled.Copy(38, 55, 41, 55, 54, 55);  oled.Copy(38, 55, 52, 55, 40, 54);  oled.Copy(40, 54, 43, 55, 37, 56);
        oled.Copy(40, 54, 41, 55, 44, 56);  oled.Copy(40, 54, 40, 55, 50, 56);  oled.Copy(40, 54, 42, 55, 55, 56);  oled.Copy(38, 55, 56, 55, 38, 58);
        oled.Copy(38, 55, 50, 55, 41, 59);  oled.Copy(43, 57, 46, 58, 46, 20);  oled.Copy(40, 54, 45, 55, 45, 22);  oled.Copy(43, 55, 46, 56, 46, 24);
}
void airC(){
    oled.line(15, 5, 80, 5, 0xBDF8);    oled.Copy(15, 5, 80, 5, 15, 6); oled.Copy(15, 5, 80, 6, 15, 7); oled.Copy(15, 5, 80, 8, 15, 9);
        oled.Copy(15, 5, 80, 6, 15, 13);    oled.Copy(15, 5, 61, 11, 15, 15);   oled.Copy(15, 15, 15, 15, 62, 15);  oled.Copy(15, 15, 15, 15, 78, 15);
        oled.Copy(62, 15, 78, 15, 62, 21);  oled.Copy(15, 15, 16, 21, 79, 15);  oled.Copy(15, 5, 80, 6, 15, 22);
    oled.fillrect(64, 17, 76, 19, 0x653E, 0x653E);                              //blue box
    oled.fillrect(15, 26, 80, 28, 0xFF2E, 0xFF2E);                              //yellow box
}
void kettleC(){
    oled.pixel(38, 5, 0x6b6d);  oled.Copy(38, 5, 38, 5, 39, 5); oled.Copy(38, 5, 39, 5, 40, 5); oled.Copy(38, 5, 40, 5, 39, 4);
        oled.Copy(38, 4, 39, 5, 35, 6); oled.Copy(38, 5, 41, 5, 37, 6); oled.Copy(38, 5, 40, 5, 37, 7); oled.Copy(35, 7, 39, 7, 34, 8);
        oled.Copy(35, 7, 38, 7, 34, 9); oled.Copy(35, 7, 38, 7, 33, 10);    oled.Copy(35, 7, 39, 7, 32, 11);    oled.Copy(39, 4, 41, 5, 61, 14);
        oled.Copy(39, 4, 41, 5, 64, 14);    oled.Copy(61, 14, 66, 14, 62, 16);  oled.Copy(61, 14, 61, 14, 69, 27);  oled.Copy(38, 4, 41, 5, 67, 28);
        oled.Copy(35, 7, 39, 7, 66, 30);    oled.Copy(35, 7, 38, 7, 66, 31);    oled.Copy(35, 7, 37, 7, 66, 32);    oled.Copy(35, 7, 36, 7, 66, 33);
        oled.Copy(34, 8, 36, 11, 24, 42);   oled.Copy(34, 8, 36, 11, 24, 46);   oled.Copy(24, 42, 26, 49, 27, 42);  oled.Copy(24, 42, 29, 49, 30, 42);
        oled.Copy(36, 6, 36, 11, 36, 44);   oled.Copy(36, 6, 36, 9, 37, 46);    oled.Copy(36, 6, 36, 8, 38, 47);    oled.Copy(36, 6, 36, 7, 39, 48);
        oled.Copy(36, 6, 36, 6, 40, 49);    oled.Copy(36, 6, 37, 6, 27, 50);
    oled.pixel(21, 52, 0x8C52); oled.Copy(21, 52, 21, 52, 22, 52);  oled.Copy(21, 52, 22, 52, 23, 52);  oled.Copy(21, 52, 24, 52, 25, 52);
        oled.Copy(21, 52, 28, 52, 29, 52);  oled.Copy(21, 52, 36, 52, 20, 53);  oled.Copy(21, 52, 36, 52, 19, 54);  oled.Copy(21, 52, 36, 52, 19, 55);
        oled.Copy(19, 54, 34, 55, 19, 56);  oled.Copy(21, 52, 36, 52, 20, 58);  oled.Copy(21, 52, 36, 52, 21, 59);  oled.Copy(19, 54, 24, 55, 23, 14);
        oled.Copy(20, 58, 24, 59, 23, 16);  oled.Copy(20, 58, 21, 59, 25, 18);  oled.Copy(21, 52, 22, 52, 27, 51);  oled.Copy(21, 52, 27, 52, 31, 14);
        oled.Copy(21, 52, 27, 52, 30, 15);  oled.Copy(21, 52, 26, 52, 30, 16);  oled.Copy(21, 52, 26, 53, 29, 17);  oled.Copy(21, 52, 27, 53, 28, 19);
        oled.Copy(21, 52, 28, 54, 27, 21);  oled.Copy(21, 52, 27, 52, 27, 24);  oled.Copy(21, 52, 27, 57, 26, 25);  oled.Copy(21, 52, 28, 57, 25, 31);
        oled.Copy(21, 52, 30, 54, 24, 37);  oled.Copy(21, 52, 21, 53, 34, 38);  oled.Copy(21, 52, 21, 52, 35, 39);  oled.Copy(21, 52, 28, 52, 67, 14);
        oled.Copy(21, 52, 29, 52, 67, 15);  oled.Copy(21, 52, 29, 52, 68, 16);  oled.Copy(23, 16, 27, 17, 72, 17);  oled.Copy(24, 16, 27, 17, 73, 19);
        oled.Copy(24, 15, 28, 16, 72, 21);  oled.Copy(24, 16, 27, 17, 71, 23);  oled.Copy(24, 15, 28, 16, 70, 25);  oled.Copy(24, 15, 26, 15, 70, 27);
        oled.Copy(27, 15, 28, 16, 71, 28);  oled.Copy(27, 58, 36, 59, 42, 4);   oled.Copy(21, 52, 33, 52, 41, 6);   oled.Copy(21, 52, 35, 52, 40, 7);
        oled.Copy(21, 52, 34, 52, 39, 8);   oled.Copy(21, 52, 35, 52, 38, 9);   oled.Copy(19, 54, 34, 55, 37, 10);  oled.Copy(21, 52, 23, 55, 53, 8);
        oled.Copy(21, 52, 21, 54, 56, 9);   oled.Copy(21, 52, 21, 52, 57, 11);
    oled.pixel(35, 54, 0xDEBB); oled.Copy(35, 54, 35, 54, 36, 54);  oled.Copy(35, 54, 36, 54, 37, 54);  oled.Copy(35, 54, 38, 54, 39, 54);
        oled.Copy(35, 54, 42, 54, 43, 54);  oled.Copy(35, 54, 50, 54, 51, 54);  oled.Copy(35, 54, 37, 54, 67, 54);  oled.Copy(35, 54, 69, 54, 35, 55);
        oled.Copy(35, 54, 69, 55, 35, 56);  oled.Copy(35, 54, 68, 54, 36, 53);  oled.Copy(35, 54, 67, 54, 36, 58);  oled.Copy(35, 54, 66, 54, 37, 52);
        oled.Copy(35, 54, 65, 54, 37, 59);  oled.Copy(35, 54, 64, 54, 36, 42);  oled.Copy(35, 54, 40, 54, 36, 43);  oled.Copy(65, 58, 68, 59, 37, 44);
        oled.Copy(35, 54, 36, 54, 38, 46);  oled.Copy(35, 54, 36, 54, 39, 47);  oled.Copy(35, 54, 36, 54, 40, 48);  oled.Copy(35, 54, 59, 54, 41, 49);
        oled.Copy(35, 54, 52, 54, 48, 43);  oled.Copy(47, 42, 63, 43, 49, 44);  oled.Copy(35, 54, 50, 54, 50, 46);  oled.Copy(35, 54, 51, 54, 49, 47);
        oled.Copy(35, 54, 52, 54, 48, 48);  oled.Copy(35, 54, 55, 54, 38, 14);  oled.Copy(35, 54, 57, 54, 37, 15);  oled.Copy(35, 54, 58, 54, 36, 16);
        oled.Copy(35, 54, 60, 54, 35, 17);  oled.Copy(35, 54, 41, 54, 35, 18);  oled.Copy(37, 17, 42, 18, 35, 19);  oled.Copy(37, 52, 40, 59, 35, 21);
        oled.Copy(35, 54, 60, 54, 35, 17);  oled.Copy(38, 14, 38, 25, 33, 25);  oled.Copy(38, 14, 38, 27, 34, 24);  oled.Copy(35, 17, 38, 26, 35, 29);
        oled.Copy(58, 14, 59, 15, 39, 33);  oled.Copy(35, 54, 37, 54, 39, 35);  oled.Copy(35, 54, 60, 56, 39, 36);  oled.Copy(35, 54, 63, 54, 36, 39);
        oled.Copy(35, 54, 48, 54, 47, 18);  oled.Copy(35, 54, 47, 54, 48, 19);  oled.Copy(35, 54, 47, 54, 49, 20);  oled.Copy(37, 52, 48, 59, 50, 21);
        oled.Copy(37, 52, 48, 58, 50, 29);  oled.Copy(35, 54, 37, 54, 47, 35);  oled.Copy(35, 54, 36, 54, 48, 34);  oled.Copy(35, 54, 35, 54, 49, 33);
        oled.Copy(35, 17, 35, 29, 62, 23);  oled.Copy(35, 17, 35, 25, 63, 27);  oled.Copy(35, 17, 35, 21, 64, 31);
    oled.pixel(41, 21, 0x96DF); oled.Copy(41, 21, 41, 21, 42, 21);  oled.Copy(41, 21, 42, 21, 43, 21);  oled.Copy(41, 21, 43, 21, 45, 21);
        oled.Copy(41, 21, 47, 21, 41, 22);  oled.Copy(41, 21, 45, 21, 42, 20);  oled.Copy(41, 21, 42, 21, 46, 23);
    oled.pixel(41, 25, 0x5DFD); oled.Copy(41, 25, 41, 25, 42, 25);  oled.Copy(41, 25, 42, 25, 43, 25);  oled.Copy(41, 25, 43, 25, 45, 25);
        oled.Copy(41, 25, 47, 25, 41, 26);  oled.Copy(41, 25, 47, 26, 41, 27);  oled.Copy(41, 25, 47, 28, 41, 29);  oled.Copy(41, 25, 42, 25, 46, 24);
        oled.Copy(41, 25, 45, 25, 42, 33);
    oled.pixel(42, 45, 0xFD36); oled.Copy(42, 45, 42, 45, 43, 45);  oled.Copy(42, 45, 43, 45, 44, 45);  oled.Copy(42, 45, 43, 45, 46, 45);
        oled.Copy(42, 45, 47, 45, 42, 46);
}
void tvC(){
    oled.pixel(36, 25, 0xFFFF); oled.Copy(36, 25, 36, 25, 37, 25);  oled.Copy(36, 25, 37, 25, 38, 25);  oled.Copy(36, 25, 39, 25, 40, 25);
        oled.Copy(36, 25, 43, 25, 44, 25);  oled.Copy(36, 25, 38, 25, 52, 25);  oled.Copy(36, 25, 54, 25, 36, 26);  oled.Copy(36, 25, 37, 26, 53, 27);
        oled.Copy(53, 25, 54, 28, 53, 29);  oled.Copy(53, 25, 54, 31, 53, 33);
    oled.pixel(32, 13, 0xDEBB); oled.Copy(32, 13, 32, 13, 33, 13);  oled.Copy(32, 13, 33, 13, 34, 13);
        oled.Copy(32, 13, 35, 13, 36, 13);  oled.Copy(32, 13, 39, 13, 40, 13); oled.Copy(32, 13, 33, 13, 48, 13);  oled.Copy(30, 2, 30, 2, 52, 13);
    oled.pixel(21, 17, 0xFDAA); oled.Copy(21, 17, 21, 17, 22, 17);  oled.Copy(21, 17, 22, 17, 23, 17);  oled.Copy(21, 17, 24, 17, 25, 17);
        oled.Copy(21, 17, 28, 17, 29, 17);  oled.Copy(21, 17, 36, 17, 37, 17);  oled.Copy(21, 17, 44, 17, 53, 17);  oled.Copy(21, 17, 76, 17, 21, 18);
        oled.Copy(21, 17, 36, 18, 61, 19);  oled.Copy(61, 17, 66, 19, 61, 21);  oled.Copy(64, 20, 67, 21, 61, 24);  oled.Copy(61, 17, 62, 25, 61, 26);
        oled.Copy(61, 17, 62, 34, 61, 35);  oled.Copy(61, 17, 61, 27, 63, 30);  oled.Copy(61, 17, 61, 25, 64, 31);  oled.Copy(63, 19, 64, 25, 65, 32);
        oled.Copy(61, 17, 62, 19, 67, 34);  oled.Copy(61, 17, 68, 20, 69, 34);  oled.Copy(61, 17, 65, 18, 72, 21);  oled.Copy(71, 20, 72, 21, 75, 23);
        oled.Copy(61, 17, 61, 20, 76, 30);  oled.Copy(61, 17, 61, 18, 75, 32);  oled.Copy(61, 17, 63, 17, 72, 33);  oled.Copy(71, 20, 74, 21, 73, 38);
        oled.Copy(71, 20, 72, 21, 75, 40);  oled.Copy(63, 30, 65, 37, 64, 47);  oled.Copy(62, 31, 66, 36, 67, 49);  oled.Copy(61, 17, 61, 25, 76, 46);
        oled.Copy(61, 17, 62, 24, 74, 47);  oled.Copy(61, 17, 61, 23, 73, 48);  oled.Copy(61, 17, 61, 22, 72, 49);  oled.Copy(61, 17, 61, 28, 63, 43);
        oled.Copy(61, 17, 62, 18, 61, 53);  oled.Copy(21, 17, 76, 17, 21, 55);
    oled.pixel(19, 17, 0xFBCA); oled.Copy(19, 17, 19, 17, 20, 17);  oled.Copy(19, 17, 20, 17, 19, 18);  oled.Copy(19, 17, 19, 18, 19, 19);
        oled.Copy(19, 17, 19, 20, 19, 21);  oled.Copy(19, 17, 19, 24, 19, 25);  oled.Copy(19, 17, 19, 32, 19, 33);  oled.Copy(19, 17, 19, 23, 19, 49);
        oled.Copy(19, 17, 19, 17, 20, 55);  oled.Copy(19, 17, 20, 17, 72, 23);  oled.Copy(19, 17, 20, 17, 74, 24);  oled.Copy(19, 17, 19, 17, 74, 23);
        oled.Copy(19, 17, 20, 17, 75, 25);  oled.Copy(19, 17, 19, 20, 76, 26);  oled.Copy(19, 17, 19, 18, 75, 30);  oled.Copy(19, 17, 19, 18, 74, 31);
        oled.Copy(19, 17, 20, 17, 72, 32);  oled.Copy(19, 17, 19, 19, 75, 41);  oled.Copy(19, 17, 19, 20, 76, 42);  oled.Copy(19, 17, 19, 17, 75, 46);
    oled.pixel(22, 21, 0x8C52); oled.Copy(22, 21, 22, 21, 22, 22);  oled.Copy(22, 21, 22, 22, 22, 23);  oled.Copy(22, 21, 22, 24, 22, 25);
        oled.Copy(22, 21, 22, 28, 22, 29);  oled.Copy(22, 21, 22, 36, 22, 37);  oled.Copy(22, 21, 22, 52, 23, 21);  oled.Copy(22, 21, 22, 21, 24, 49);
        oled.Copy(22, 21, 23, 42, 28, 24);  oled.Copy(22, 21, 23, 42, 30, 24);  oled.Copy(28, 24, 31, 45, 32, 24);  oled.Copy(28, 27, 35, 45, 36, 27);
        oled.Copy(28, 27, 36, 45, 44, 27);  oled.Copy(28, 27, 47, 27, 36, 24);  oled.Copy(28, 24, 28, 38, 55, 25);  oled.Copy(28, 24, 30, 29, 53, 40);
        oled.Copy(28, 27, 43, 28, 40, 46);  oled.Copy(28, 45, 55, 45, 28, 48);  oled.Copy(22, 21, 22, 47, 58, 23);  oled.Copy(22, 21, 22, 21, 57, 49);
        oled.Copy(22, 21, 22, 26, 65, 25);  oled.Copy(22, 21, 22, 28, 66, 24);  oled.Copy(22, 21, 22, 29, 69, 23);  oled.Copy(22, 21, 22, 28, 72, 24);
        oled.Copy(22, 21, 22, 26, 73, 25);  oled.Copy(28, 24, 29, 24, 69, 38);  oled.Copy(28, 24, 30, 24, 67, 39);  oled.Copy(28, 24, 30, 24, 66, 40);
        oled.Copy(28, 24, 30, 24, 65, 41);  oled.Copy(28, 24, 29, 24, 65, 42);  oled.Copy(28, 24, 29, 24, 64, 43);  oled.Copy(28, 24, 28, 24, 64, 44);
        oled.Copy(28, 24, 29, 25, 71, 40);  oled.Copy(28, 24, 29, 25, 70, 41);  oled.Copy(70, 40, 72, 42, 68, 42);  oled.Copy(70, 40, 72, 42, 66, 44);
        oled.Copy(57, 48, 58, 49, 73, 42);  oled.Copy(69, 40, 72, 43, 70, 44);  oled.Copy(57, 48, 58, 49, 68, 47);
    oled.pixel(24, 21, 0xC639); oled.Copy(24, 21, 24, 21, 25, 21);  oled.Copy(24, 21, 25, 21, 26, 21);  oled.Copy(24, 21, 27, 21, 28, 21);
        oled.Copy(24, 21, 31, 21, 32, 21);  oled.Copy(24, 21, 39, 21, 40, 21);  oled.Copy(24, 21, 26, 21, 56, 21);  oled.Copy(24, 21, 25, 21, 24, 22);
        oled.Copy(24, 21, 24, 21, 24, 23);  oled.Copy(24, 21, 26, 21, 56, 22);  oled.Copy(24, 21, 24, 21, 57, 23);  oled.Copy(24, 21, 25, 21, 24, 50);
        oled.Copy(24, 21, 26, 21, 56, 50);  oled.Copy(24, 21, 58, 21, 24, 51);  oled.Copy(24, 21, 58, 21, 24, 52);
    oled.pixel(26, 24, 0x39E8); oled.Copy(26, 24, 26, 24, 26, 25);  oled.Copy(26, 24, 26, 25, 26, 26);  oled.Copy(26, 24, 26, 27, 26, 28);
        oled.Copy(26, 24, 26, 31, 26, 32);  oled.Copy(26, 24, 26, 32, 26, 40);  oled.Copy(26, 24, 26, 48, 27, 24);  oled.Copy(26, 24, 27, 25, 22, 58);
        oled.Copy(26, 24, 26, 25, 24, 58);  oled.Copy(22, 58, 24, 59, 67, 58);
    oled.pixel(25, 58, 0x7BB0); oled.Copy(25, 58, 25, 58, 26, 58);  oled.Copy(25, 58, 26, 58, 27, 58);  oled.Copy(25, 58, 28, 58, 25, 59);
        oled.Copy(25, 58, 28, 59, 70, 58);
}
void radioC(){
    oled.pixel(40, 13, 0x687D); oled.Copy(40, 13, 40, 13, 39, 14);  oled.Copy(40, 13, 40, 13, 40, 14);  oled.Copy(40, 13, 40, 13, 41, 14);
        oled.Copy(40, 13, 40, 13, 40, 15);  oled.Copy(39, 13, 41, 15, 45, 13);  oled.Copy(39, 13, 41, 15, 54, 20);
    oled.pixel(23, 25, 0x2BB7); oled.Copy(23, 25, 23, 25, 24, 25);  oled.Copy(23, 25, 24, 25, 25, 25);  oled.Copy(23, 25, 26, 25, 27, 25);
        oled.Copy(23, 25, 30, 25, 23, 26);  oled.Copy(23, 25, 30, 26, 37, 25);
    oled.pixel(71, 4, 0xFDE8); oled.Copy(71, 4, 71, 4, 72, 4);  oled.Copy(71, 4, 72, 4, 71, 5); oled.Copy(71, 4, 72, 5, 70, 6);
        oled.Copy(71, 4, 72, 5, 72, 6); oled.Copy(70, 6, 73, 7, 70, 8); oled.Copy(70, 6, 73, 7, 69, 25);    oled.Copy(70, 6, 71, 7, 73, 25);
    oled.pixel(19, 29, 0xEB4D); oled.Copy(19, 29, 19, 29, 20, 29);   oled.Copy(19, 29, 20, 29, 21, 29);  oled.Copy(19, 29, 22, 29, 23, 29);
        oled.Copy(19, 29, 26, 29, 27, 29);  oled.Copy(19, 29, 34, 29, 35, 29);  oled.Copy(19, 29, 44, 29, 51, 29);  oled.Copy(19, 29, 76, 29, 19, 30);
        oled.Copy(19, 29, 47, 29, 48, 31);  oled.Copy(19, 29, 27, 29, 48, 32);  oled.Copy(19, 29, 26, 29, 48, 33);  oled.Copy(19, 29, 25, 29, 48, 34);
        oled.Copy(51, 32, 56, 34, 48, 35);  oled.Copy(48, 29, 50, 31, 48, 38);  oled.Copy(19, 29, 48, 30, 21, 41);  oled.Copy(19, 29, 37, 30, 32, 43);
        oled.Copy(19, 29, 48, 30, 21, 45);  oled.Copy(19, 29, 48, 30, 21, 47);  oled.Copy(19, 29, 48, 30, 21, 49);  oled.Copy(19, 29, 38, 29, 32, 51);
        oled.Copy(19, 29, 38, 29, 33, 52);  oled.Copy(19, 29, 38, 29, 34, 53);  oled.Copy(19, 29, 39, 29, 34, 54);  oled.Copy(19, 29, 40, 29, 34, 55);
        oled.Copy(19, 29, 27, 29, 68, 32);  oled.Copy(32, 51, 39, 52, 69, 33);  oled.Copy(68, 32, 73, 34, 71, 35);  oled.Copy(48, 29, 50, 46, 74, 38);
        oled.Copy(47, 40, 48, 41, 72, 51);  oled.Copy(72, 50, 76, 52, 69, 53);  oled.Copy(19, 29, 61, 30, 34, 56);  oled.Copy(48, 31, 49, 50, 19, 31);
        oled.Copy(19, 29, 19, 35, 19, 51);  oled.Copy(20, 30, 21, 31, 20, 51);  oled.Copy(20, 30, 21, 31, 27, 51);  oled.Copy(47, 30, 48, 31, 25, 51);
        oled.Copy(47, 30, 48, 31, 32, 51);  oled.Copy(20, 40, 21, 41, 20, 56);  oled.Copy(20, 40, 21, 41, 27, 56);  oled.Copy(47, 40, 48, 41, 25, 56);
        oled.Copy(47, 40, 48, 41, 32, 56);  oled.Copy(19, 29, 76, 30, 19, 58);
    oled.Copy(16, 62, 38, 62, 23, 33);  oled.Copy(33, 22, 36, 26, 23, 34);  oled.Copy(33, 22, 36, 26, 27, 34);  oled.Copy(33, 22, 36, 26, 31, 34);
        oled.Copy(33, 22, 36, 26, 35, 34);  oled.Copy(33, 25, 34, 26, 25, 35);  oled.Copy(33, 25, 34, 25, 33, 35);  oled.Copy(33, 22, 33, 26, 39, 34);
        oled.Copy(31, 34, 36, 38, 40, 34);  oled.Copy(37, 10, 39, 12, 21, 52);  oled.Copy(38, 17, 39, 18, 24, 52);  oled.Copy(49, 5, 50, 6, 21, 55);
        oled.Copy(48, 15, 50, 17, 23, 54);
    oled.pixel(23, 53, 0xFF2E); oled.Copy(23, 53, 23, 53, 22, 54);  oled.Copy(23, 53, 23, 53, 23, 54);  oled.Copy(23, 53, 23, 53, 24, 54);
        oled.Copy(23, 53, 23, 53, 23, 55);  oled.Copy(21, 52, 25, 56, 28, 52);
    oled.pixel(52, 39, 0xCEFD); oled.Copy(52, 39, 52, 39, 52, 40);  oled.Copy(52, 39, 52, 40, 52, 41);  oled.Copy(52, 39, 52, 42, 52, 43);
        oled.Copy(52, 39, 52, 41, 52, 47);  oled.Copy(52, 39, 52, 44, 53, 38);  oled.Copy(52, 39, 52, 44, 53, 45);  oled.Copy(52, 38, 53, 42, 54, 36);
        oled.Copy(52, 39, 53, 40, 54, 42);  oled.Copy(52, 39, 53, 40, 54, 45);  oled.Copy(52, 46, 53, 50, 54, 48);  oled.Copy(52, 39, 52, 42, 56, 35);
        oled.Copy(52, 39, 52, 43, 56, 49);  oled.Copy(52, 38, 53, 43, 57, 33);  oled.Copy(52, 39, 53, 40, 57, 39);  oled.Copy(52, 39, 53, 40, 57, 42);
        oled.Copy(52, 39, 53, 40, 57, 45);  oled.Copy(57, 34, 58, 40, 57, 48);  oled.Copy(52, 39, 52, 42, 59, 33);  oled.Copy(52, 39, 52, 42, 59, 51);
        oled.Copy(57, 34, 58, 54, 60, 34);  oled.Copy(55, 36, 61, 36, 60, 33);  oled.Copy(52, 39, 52, 39, 62, 34);  oled.Copy(52, 39, 52, 40, 62, 53);
        oled.Copy(57, 34, 61, 54, 63, 34);  oled.Copy(52, 39, 52, 42, 68, 35);  oled.Copy(52, 39, 52, 43, 68, 49);  oled.Copy(67, 34, 68, 38, 69, 36);
        oled.Copy(57, 42, 58, 46, 69, 42);  oled.Copy(69, 37, 70, 40, 69, 48);  oled.Copy(52, 39, 52, 39, 69, 52);
        oled.Copy(66, 33, 67, 38, 71, 38);  oled.Copy(66, 34, 67, 38, 71, 45);  oled.Copy(52, 39, 52, 39, 72, 44);  oled.Copy(52, 39, 52, 39, 71, 50);
}


bool statuselec[5] = {false, false, false, false, false};
int speedFan = 0, channelTv = 0, volumeTv = 0, volumeRadio = 0;
float tempKettle = 0.00, tempAir = 0.00, tempAirSet = 0.00, channelRadio = 0.00;
char On[] = "ON", Off[] = "OFF";
uint8_t dataa, mainState = 0, preState = 0;
uint8_t step = 1, preStep = 9;
uint8_t err;
int game = 10000;




void sta(uint8_t a){
    status.locate(1, 10);
    if(statuselec[a-1]) status.printf("Power : %s  ", On);
    else                status.printf("Power : %s  ", Off);
    if(a == 1){
        status.locate(1, 30);
        status.printf("Speed : %d   ", speedFan);
        status.locate(1, 50);
        status.printf("             ");
    }
    else if(a == 2){
        status.locate(1, 30);
        status.printf("Temp : %.2f C   ", tempAir);
        status.locate(1, 50);
        status.printf("Set : %.2f C   ", tempAirSet);
    }
    else if(a == 3){
        status.locate(1, 30);
        status.printf("Temp : %.2f C   ", tempKettle);
        status.locate(1, 50);
        status.printf("                ");
    }
    else if(a == 4){
        status.locate(1, 30);
        status.printf("Channel : %d   ", channelTv);
        status.locate(1, 50);
        status.printf("Volume : %d   ", volumeTv);
    }
    else if(a == 5){
        status.locate(1, 30);
        status.printf("Channel : %d   ", channelRadio);
        status.locate(1, 50);
        status.printf("Volume : %d   ", volumeRadio);
    }
}



int main() {
    pc.baud(38400);
    bt.baud(38400);
    minn.start();
    tt.start();
    status.SetFontSize(NORMAL);
    status.foreground(0xFFFF);
    pc.printf("eiei\n");
    while(!bt.readable()){
        if(minn.read_ms() >= 10){
            bt.printf("%c", '0');
            minn.reset();
        }
    }
    dataa = bt.getc();
    
    
    
    
    /*
    while(true){
        tempKettle = get_temp(ram::T_obj1);
        err = airTemp.readData();
        if (err == 0)   tempAir = airTemp.ReadTemperature(CELCIUS);
        tempAirSet = tempAir;
        if(bt.readable()){
            dataa = bt.getc();
            pc.printf("eiei2\n");
            break;
        }
        if(minn.read_ms() >= 5000){
            step += 1;
            minn.reset();
        }
        if(step >= 6)   step = 1;
        if(step == 1){
            if(preStep != 1){
                preStep = 1;
                fanW();
                fanC();
                status.cls();
            }
            status.locate(1, 10);
            if(statusFan)   status.printf("Power : %s   ", On);
            else            status.printf("Power : %s   ", Off);
            status.locate(1, 30);
            status.printf("Speed : %d   ", speedFan);
            
        }
        else if(step == 2){
            if(preStep != 2){
                preStep = 2;
                airW();
                airC();
                status.cls();
            }
            status.locate(1, 10);
            if(statusAir)   status.printf("Power : %s   ", On);
            else            status.printf("Power : %s   ", Off);
            status.locate(1, 30);
            status.printf("Temp : %.2f C   ", tempAir);
            status.locate(1, 50);
            status.printf("Set : %.2f C   ", tempAirSet);
        }
        else if(step == 3){
            if(preStep != 3){
                preStep = 3;
                kettleW();
                kettleC();
                status.cls();
            }
            status.locate(1, 10);
            if(statusKettle)    status.printf("Power : %s   ", On);
            else                status.printf("Power : %s   ", Off);
            status.locate(1, 30);
            status.printf("Temp : %.2f C   ", tempKettle);
        }
        else if(step == 4){
            if(preStep != 4){
                preStep = 4;
                tvW();
                tvC();
                status.cls();
            }
            status.locate(1, 10);
            if(statusTv)    status.printf("Power : %s   ", On);
            else            status.printf("Power : %s   ", Off);
            status.locate(1, 30);
            status.printf("Channel : %d   ", channelTv);
            status.locate(1, 50);
            status.printf("Volume : %d   ", volumeTv);
        }
        else if(step == 5){
            if(preStep != 5){
                preStep = 5;
                radioW();
                radioC();
                status.cls();
            }
            status.locate(1, 10);
            if(statusRadio) status.printf("Power : %s   ", On);
            else            status.printf("Power : %s   ", Off);
            status.locate(1, 30);
            status.printf("Channel : %d   ", channelRadio);
            status.locate(1, 50);
            status.printf("Volume : %d   ", volumeRadio);
        }
    }
    */
    
    
    
    
    
//    motorFan.period_ms(12);
//    motorAir.period_ms(30);
    
    //motorFan.period_ms(12);
//    motorFan.write(0.5);
//    motorAir.period_ms(12);
//    motorAir.write(0.5);
    
    
    
    tempKettle = get_temp(ram::T_obj1);
    err = airTemp.readData();
    if (err == 0)   tempAir = airTemp.ReadTemperature(CELCIUS);
    tempAirSet = tempAir;
    tt.reset();
    step = 5, preStep = 9;
//    tempAir = 25;//////////////////////////////////////////////////////////////////////////////////////
//    tempAirSet = tempAir;
    while(1){
        tempKettle = get_temp(ram::T_obj1);
        err = airTemp.readData();
        if (err == 0)   tempAir = airTemp.ReadTemperature(CELCIUS);
        if(bt.readable()){
            dataa = bt.getc();
        }
        if(minn.read_ms() >= 10){
            bt.printf("%c", mainState+48);
            pc.printf("\t\t\t%c\n", mainState+48);
            minn.reset();
        }
        
        
        
        if(statuselec[0]){
//            motorFan.write(/*speedFan*0.33*/1);
            motorFan = speedFan*0.33;
        }
        else motorFan = 0;
        if(statuselec[1]){
            //motorAir.write(0.5+(tempAir-tempAirSet)/100);
            motorAir = 0.5+(tempAir-tempAirSet)/100;
        }
        else motorAir = 0;
        
        
        while(mainState == 0){
            if(bt.readable()){
                dataa = bt.getc();
            }
            if(dataa == '1'){
                dataa = 0;
                if(preStep != 1){
                    preStep = 1;
                    fanW();
                    status.cls();
                }
//                sta(1);
            }
            else if(dataa == '2'){
                dataa = 0;
                if(preStep != 2){
                    preStep = 2;
                    airW();
                    status.cls();
                }
//                sta(2);
            }
            else if(dataa == '3'){
                dataa = 0;
                if(preStep != 3){
                    preStep = 3;
                    kettleW();
                    status.cls();
                }
//                sta(3);
            }
            else if(dataa == '4'){
                dataa = 0;
                if(preStep != 4){
                    preStep = 4;
                    tvW();
                    status.cls();
                }
//                sta(4);
            }
            else if(dataa == '5'){
                dataa = 0;
                if(preStep != 5){
                    preStep = 5;
                    radioW();
                    status.cls();
                }
//                sta(5);
            }
            else if(dataa == '6' || dataa == '0'){
                dataa = 0;
                preStep = 0;
                oled.cls();
                status.cls();
            }
            else if(dataa == 'b')   mainState = 1;
            else if(dataa == 'c')   mainState = 2;
            else if(dataa == 'd')   mainState = 3;
            else if(dataa == 'e')   mainState = 4;
            else if(dataa == 'f')   mainState = 5;
            if(mainState != 0 || minn.read_ms() >= 10){
                bt.printf("%c", mainState+48);
                pc.printf("\t\t%c\n", mainState+48);
                status.cls();
                minn.reset();
                tt.reset();
                dataa = 0;
            }
            preState = 9;
        }
        if(dataa == 'A'){
            statuselec[0] = true;
            dataa = 0;
        }
        else if(dataa == 'B'){
            statuselec[0] = false;
            dataa = 0;
        }
        else if(dataa == 'C'){
            dataa = 0;
            speedFan -= 1;
            if(speedFan < 0)    speedFan = 3;
        }
        else if(dataa == 'D'){
            dataa = 0;
            speedFan += 1;
            if(speedFan > 3)    speedFan = 0;
        }
        else if(dataa == 'E'){
            statuselec[1] = true;
            dataa = 0;
        }
        else if(dataa == 'F'){
            statuselec[1] = false;
            dataa = 0;
        }
        else if(dataa == 'G'){
            dataa = 0;
            tempAirSet -= 1;
            if(tempAirSet < 18)    tempAirSet = tempAir;
        }
        else if(dataa == 'H'){
            dataa = 0;
            tempAirSet += 1;
            if(tempAirSet > 30)    tempAirSet = tempAir;
        }
        else if(dataa == 'I'){
            statuselec[2] = true;
            dataa = 0;
        }
        else if(dataa == 'J'){
            statuselec[2] = false;
            dataa = 0;
        }
        else if(dataa == 'K'){
            statuselec[3] = true;
            dataa = 0;
        }
        else if(dataa == 'L'){
            statuselec[3] = false;
            dataa = 0;
        }
        else if(dataa == 'M'){
            dataa = 0;
            volumeTv -= 1;
            if(volumeTv < 0){
                volumeTv = 0;
            }
        }
        else if(dataa == 'N'){
            dataa = 0;
            volumeTv += 1;
            if(volumeTv > 100){
                volumeTv = 100;
            }
        }   
        else if(dataa == 'O'){
            statuselec[4] = true;
            dataa = 0;
        }
        else if(dataa == 'P'){
            statuselec[4] = false;
            dataa = 0;
        }
        else if(dataa == 'Q'){
            dataa = 0;
            volumeRadio -= 1;
            if(volumeRadio < 0){
                volumeRadio = 0;
            }
        }
        else if(dataa == 'R'){
            dataa = 0;
            volumeRadio += 1;
            if(volumeRadio > 100){
                volumeRadio = 100;
            }
        }
        else if(dataa == 'T'){
            dataa = 0;
            channelRadio -= 1;
            if(channelRadio < 0){
                channelRadio = 0;
            }
        }
        else if(dataa == 'U'){
            dataa = 0;
            channelRadio += 1;
            if(channelRadio > 100){
                channelRadio = 100;
            }
        }
        else    dataa = 0;
        if(tt.read_ms() >= game){
            mainState = 0;
            oled.cls();
            bt.printf("%c", mainState+48);
            pc.printf("\t%c\n", mainState+48);
        }
        if(mainState == 1){
            if(preState != 1){
                fanW();
                fanC();
                status.cls();
                preState = 1;
                tt.reset();
            }
            sta(1);
        }
        else if(mainState == 2){
            if(preState != 2){
                airW();
                airC();
                status.cls();
                preState = 2;
                tt.reset();
            }
            sta(2);
        }
        else if(mainState == 3){
            if(preState != 3){
                kettleW();
                kettleC();
                status.cls();
                preState = 3;
                tt.reset();
            }
            sta(3);
        }
        else if(mainState == 4){
            if(preState != 4){
                tvW();
                tvC();
                status.cls();
                preState = 4;
                tt.reset();
            }
            sta(4);
        }
        else if(mainState == 5){
            if(preState != 5){
                radioW();
                radioC();
                status.cls();
                preState = 5;
                tt.reset();
            }
            sta(5);
        }
        
    }
}