#ifndef _KEYMAPS_H_
#define _KEYMAPS_H_

#include "mbed.h"
/**
* Layout transition is usually handled by host OS
* if not, a different layout can be forced here
*/
enum LAYOUTS {
    LO_US=1,
    LO_DE,
    LO_UK
};

class Keymaps
{
public:
    /**
    *   Constructor
    *
    *
    * @param layout: Layout of PS/2 keyboard, for handling of additional/alternate keys
    * @param ext: keymap for keys with E0-prefixed PS/2-scancodes
    *
    */
    Keymaps(LAYOUTS layout, bool ext);

    /**
    * Array that references USB HID codes from PS/2 scancode suffix
    */
    uint8_t K[255];
};
#endif