#include "Keymaps.h"
/**
*
* key description allways references US layout
* Codes from https://download.microsoft.com/download/1/6/1/161ba512-40e2-4cc9-843a-923143f3456c/translate.pdf
*/
Keymaps::Keymaps(LAYOUTS layout, bool ext)
{
    if(ext) { // keys with E0 prefix
        switch (layout) {
            case LO_DE:
                K[0x11] = 230; /* Right Alt  */
                K[0x14] = 228; /* Right Control  */
                K[0x1F] = 227; /* Left GUI  */
                K[0x27] = 231; /* Right GUI  */
                K[0x2F] = 101; /* App  */
                K[0x37] = 102; /* Keyboard Power  */
                K[0x4A] = 84; /* Keypad / (Note 1)  */
                K[0x5A] = 88; /* Keypad Enter  */
                K[0x69] = 77; /* End (Note 1)  */
                K[0x6B] = 80; /* Left Arrow (Note 1)  */
                K[0x6C] = 74; /* Home (Note 1)  */
                K[0x70] = 73; /* Insert (Note 1)  */
                K[0x71] = 76; /* Delete (Note 1)  */
                K[0x72] = 81; /* Down Arrow (Note 1)  */
                K[0x74] = 79; /* Right Arrow (Note 1)  */
                K[0x75] = 82; /* Up Arrow (Note 1)  */
                K[0x7A] = 78; /* Page Down (Note 1)  */
                K[0x7C] = 70; /* Print Screen (Note 1)  */
                K[0x7D] = 75; /* Page Up (Note 1)  */
                break;
            default: //US as HID Standard
                K[0x11] = 230; /* RAlt */
                K[0x14] = 228; /* RCtrl */
                K[0x70] = 73; /* Insert */
                K[0x71] = 76; /* Delete */
                K[0x6c] = 74; /* Home */
                K[0x69] = 77; /* End */
                K[0x7d] = 75; /* PgUp */
                K[0x7a] = 78; /* PgDn */
                K[0x6b] = 80; /* Left */
                K[0x75] = 82; /* Up */
                K[0x72] = 81; /* Down */
                K[0x74] = 79; /* Right */
                K[0x4a] = 84; /* KP-/ */
                K[0x5a] = 88; /* KP-Enter */
                K[0x7c] = 70; /* PrtScr */
                K[0x7e] = 48; /* Ctrl+Break */
                K[0x1f] = 227; /* LWin (USB: LGUI) */
                K[0x27] = 231; /* RWin (USB: RGUI) */
                K[0x2f] = 101; /* Menu */
                K[0x3f] = 0; /* Sleep */
                K[0x37] = 0; /* Power */
                K[0x5e] = 0; /* Wake */
                break;
        }

    } else {
        switch (layout) {
            case LO_DE:
                K[0x1] = 66; /* F9  */
                K[0x3] = 62; /* F5  */
                K[0x4] = 60; /* F3  */
                K[0x5] = 58; /* F1  */
                K[0x6] = 59; /* F2  */
                K[0x7] = 69; /* F12  */
                K[0x8] = 104; /* F13  */
                K[0x9] = 67; /* F10  */
                K[0x10] = 105; /* F14  */
                K[0x11] = 226; /* Left Alt  */
                K[0x12] = 225; /* Left Shift  */
                K[0x13] = 136; /* Keyboard Intl'2 かかかかひひひかロロロ字  */
                K[0x14] = 224; /* Left Control  */
                K[0x15] = 20; /* q Q  */
                K[0x16] = 30; /* 1 !  */
                K[0x18] = 106; /* F15  */
                K[0x20] = 107; /* F16  */
                K[0x21] = 6; /* c C  */
                K[0x22] = 27; /* x X  */
                K[0x23] = 7; /* d D  */
                K[0x24] = 8; /* e E  */
                K[0x25] = 33; /* 4 $  */
                K[0x26] = 32; /* 3 #  */
                K[0x27] = 140; /* Keyboard Int'l 6 (PC9800 Keypad , )  */
                K[0x28] = 108; /* F17  */
                K[0x29] = 44; /* Space  */
                K[0x30] = 109; /* F18  */
                K[0x31] = 17; /* n N  */
                K[0x32] = 5; /* b B  */
                K[0x33] = 11; /* h H  */
                K[0x34] = 10; /* g G  */
                K[0x35] = 28; /* y Y  */
                K[0x36] = 35; /* 6 ^  */
                K[0x38] = 110; /* F19  */
                K[0x40] = 111; /* F20  */
                K[0x41] = 54; /* , <  */
                K[0x42] = 14; /* k K  */
                K[0x43] = 12; /* i I  */
                K[0x44] = 18; /* o O  */
                K[0x45] = 39; /* 0 )  */
                K[0x46] = 38; /* 9 (  */
                K[0x48] = 112; /* F21  */
                K[0x49] = 55; /* . >  */
                K[0x50] = 113; /* F22  */
                K[0x51] = 135; /* Keyboard Int'l 1 ろ  */
                K[0x52] = 52; /* ' "  */
                K[0x54] = 47; /* [ {  */
                K[0x55] = 46; /* = +  */
                K[0x57] = 114; /* F23  */
                K[0x58] = 57; /* Caps Lock  */
                K[0x59] = 229; /* Right Shift  */
                K[0x61] = 100; /* Europe 2 (Note 2)  */
                K[0x62] = 147; /* Keyboard Lang 4 ひひひか  */
                K[0x63] = 146; /* Keyboard Lang 3 かかかか  */
                K[0x64] = 138; /* Keyboard Int'l 4 前前前  */
                K[0x66] = 42; /* Backspace  */
                K[0x67] = 139; /* Keyboard Int'l 5 無変変  */
                K[0x69] = 89; /* Keypad 1 End  */
                K[0x70] = 98; /* Keypad 0 Insert  */
                K[0x71] = 99; /* Keypad . Delete  */
                K[0x72] = 90; /* Keypad 2 Down  */
                K[0x73] = 93; /* Keypad 5  */
                K[0x74] = 94; /* Keypad 6 Right  */
                K[0x75] = 96; /* Keypad 8 Up  */
                K[0x76] = 41; /* Escape  */
                K[0x77] = 83; /* Num Lock  */
                K[0x78] = 68; /* F11  */
                K[0x79] = 87; /* Keypad +  */
                K[0x83] = 64; /* F7  */
                K[0x0A] = 65; /* F8  */
                K[0x0B] = 63; /* F6  */
                K[0x0C] = 61; /* F4  */
                K[0x0D] = 43; /* Tab  */
                K[0x0E] = 53; /* ` ~  */
                K[0x0F] = 103; /* Keypad =  */
                K[0x1A] = 29; /* z Z  */
                K[0x1B] = 22; /* s S  */
                K[0x1C] = 4; /* a A  */
                K[0x1D] = 26; /* w W  */
                K[0x1E] = 31; /* 2 @  */
                K[0x2A] = 25; /* v V  */
                K[0x2B] = 9; /* f F  */
                K[0x2C] = 23; /* t T  */
                K[0x2D] = 21; /* r R  */
                K[0x2E] = 34; /* 0,05 */
                K[0x3A] = 16; /* m M  */
                K[0x3B] = 13; /* j J  */
                K[0x3C] = 24; /* u U  */
                K[0x3D] = 36; /* 7 &  */
                K[0x3E] = 37; /* 8 *  */
                K[0x4A] = 56; /* / ?  */
                K[0x4B] = 15; /* l L  */
                K[0x4C] = 51; /* ; :  */
                K[0x4D] = 19; /* p P  */
                K[0x4E] = 45; /* - _  */
                K[0x5A] = 40; /* Return  */
                K[0x5B] = 48; /* ] }  */
                K[0x5D] = 50; /* Europe 1*/
                K[0x5F] = 115; /* F24  */
                K[0x5F] = 148; /* Keyboard Lang 5  */
                K[0x6A] = 137; /* Keyboard Int'l 2  */
                K[0x6B] = 92; /* Keypad 4 Left  */
                K[0x6C] = 95; /* Keypad 7 Home  */
                K[0x6D] = 133; /* Keypad , (Brazilian Keypad .)  */
                K[0x7A] = 91; /* Keypad 3 PageDn  */
                K[0x7B] = 86; /* Keypad -  */
                K[0x7C] = 85; /* Keypad *  */
                K[0x7D] = 97; /* Keypad 9 PageUp  */
                K[0x7E] = 71; /* Scroll Lock  */
                K[0xF1] = 145; /* Keyboard Lang 2  */
                K[0xF2] = 144; /* Keyboard Lang 1 한옝/  */
                K[0xFC] = 2; /* POST Fail  */
                break;
            default: //US as HID Standard
                K[0x0e] = 53; /* ` ~ */
                K[0x16] = 30; /* 1 ! */
                K[0x1e] = 31; /* 2 @ */
                K[0x26] = 32; /* 3 # */
                K[0x25] = 33; /* 4 $ */
                K[0x2e] = 34; /* 5 % E */
                K[0x36] = 35; /* 6 ^ */
                K[0x3d] = 36; /* 7 & */
                K[0x3e] = 37; /* 8 * */
                K[0x46] = 38; /* 9 ( */
                K[0x45] = 39; /* 0 ) */
                K[0x4e] = 45; /* - _ */
                K[0x55] = 46; /* = + */
                K[0x66] = 42; /* Backspace */
                K[0x0d] = 43; /* Tab */
                K[0x15] = 20; /* Q */
                K[0x1d] = 26; /* W */
                K[0x24] = 8; /* E */
                K[0x2d] = 21; /* R */
                K[0x2c] = 23; /* T */
                K[0x35] = 28; /* Y */
                K[0x3c] = 24; /* U */
                K[0x43] = 12; /* I */
                K[0x44] = 18; /* O */
                K[0x4d] = 19; /* P */
                K[0x54] = 47; /* [ { */
                K[0x5b] = 48; /* ] } */
                K[0x5d] = 49; /* \ | */
                K[0x58] = 57; /* CapsLock */
                K[0x1c] = 4; /* A */
                K[0x1b] = 22; /* S */
                K[0x23] = 7; /* D */
                K[0x2b] = 9; /* F */
                K[0x34] = 10; /* G */
                K[0x33] = 11; /* H */
                K[0x3b] = 13; /* J */
                K[0x42] = 14; /* K */
                K[0x4b] = 15; /* L */
                K[0x4c] = 51; /* ; : */
                K[0x52] = 52; /* ' " */
                K[0x61] = 100; /* Europe 2*/
                K[0x5a] = 40; /* Enter */
                K[0x12] = 225; /* LShift */
                K[0x1a] = 29; /* Z */
                K[0x22] = 27; /* X */
                K[0x21] = 6; /* C */
                K[0x2a] = 25; /* V */
                K[0x32] = 5; /* B */
                K[0x31] = 17; /* N */
                K[0x3a] = 16; /* M */
                K[0x41] = 54; /* , < */
                K[0x49] = 55; /* . > */
                K[0x4a] = 56; /* / ? */
                K[0x59] = 229; /* RShift */
                K[0x14] = 224; /* LCtrl */
                K[0x11] = 226; /* LAlt */
                K[0x29] = 44; /* space */
                K[0x77] = 83; /* NumLock */
                K[0x6c] = 95; /* KP-7 / Home */
                K[0x6b] = 92; /* KP-4 / Left */
                K[0x69] = 89; /* KP-1 / End */
                K[0x75] = 96; /* KP-8 / Up */
                K[0x73] = 93; /* KP-5 */
                K[0x72] = 90; /* KP-2 / Down */
                K[0x70] = 98; /* KP-0 / Ins */
                K[0x7c] = 85; /* KP-* */
                K[0x7d] = 97; /* KP-9 / PgUp */
                K[0x74] = 94; /* KP-6 / Right */
                K[0x7a] = 91; /* KP-3 / PgDn */
                K[0x71] = 99; /* KP-. / Del */
                K[0x7b] = 86; /* KP-- */
                K[0x79] = 87; /* KP-+ */
                K[0x76] = 41; /* Esc */
                K[0x5] = 58; /* F1 */
                K[0x6] = 59; /* F2 */
                K[0x4] = 60; /* F3 */
                K[0x0c] = 61; /* F4 */
                K[0x3] = 62; /* F5 */
                K[0x0b] = 63; /* F6 */
                K[0x83] = 64; /* F7 */
                K[0x0a] = 65; /* F8 */
                K[0x1] = 66; /* F9 */
                K[0x9] = 67; /* F10 */
                K[0x78] = 68; /* F11 */
                K[0x7] = 69; /* F12 */
                K[0x84] = 154; /* Alt+SysRq */
                K[0x7e] = 71; /* ScrollLock */
                break;
        }
    }
}