/**
 * UIPEthernet Project-specific configuration options
 * Copyright (c) 2013 Norbert Truchsess <norbert.truchsess@t-online.de>
 * @{
 *
 * UIP has a number of configuration options that can be overridden
 * for each project. These are kept in a project-specific uip-conf.h
 * file and all configuration names have the prefix UIP_CONF.
 */
/*
 * Copyright (c) 2006, Swedish Institute of Computer Science.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is part of the UIP TCP/IP stack
 *
 */
#ifndef __UIP_CONF_H__
#define __UIP_CONF_H__

#include <inttypes.h>
#include "uipethernet-conf.h"

/**
 * 8 bit datatype
 *
 * This typedef defines the 8-bit type used throughout UIP.
 *
 * \hideinitializer
 */
typedef uint8_t         u8_t;

/**
 * 16 bit datatype
 *
 * This typedef defines the 16-bit type used throughout UIP.
 *
 * \hideinitializer
 */
typedef uint16_t        u16_t;

/**
 * Statistics datatype
 *
 * This typedef defines the dataype used for keeping statistics in
 * UIP.
 *
 * \hideinitializer
 */
typedef unsigned short  uip_stats_t;

/**
 * Maximum number of TCP connections.
 * (see uipethernet-conf.h)
 * \hideinitializer
 *
 * #define UIP_CONF_MAX_CONNECTIONS 4
 */

/**
 * Maximum number of listening TCP ports.
 *
 * \hideinitializer
 */
#define UIP_CONF_MAX_LISTENPORTS    4

/**
 * UIP buffer size.
 *
 * \hideinitializer
 */

#define UIP_CONF_BUFFER_SIZE    98
//#define UIP_CONF_BUFFER_SIZE     118

/**
 * The TCP maximum segment size.
 *
 * This is should not be to set to more than
 * UIP_BUFSIZE - UIP_LLH_LEN - UIP_TCPIP_HLEN.
 */
#define UIP_CONF_TCP_MSS    512

/**
 * The size of the advertised receiver's window.
 *
 * Should be set low (i.e., to the size of the uip_buf buffer) is the
 * application is slow to process incoming data, or high (32768 bytes)
 * if the application processes data quickly.
 *
 * \hideinitializer
 */

#define UIP_CONF_RECEIVE_WINDOW 512

/**
 * CPU byte order.
 *
 * \hideinitializer
 */

#define UIP_CONF_BYTE_ORDER UIP_LITTLE_ENDIAN

/**
 * Logging on or off
 *
 * \hideinitializer
 */

#define UIP_CONF_LOGGING    0

/**
 * UDP support on or off
 * (see uipethernet-conf.h)
 * \hideinitializer
 *
 * #define UIP_CONF_UDP             1
 *
 * #define UIP_CONF_UDP_CONNS       4
 */

/**
 * UDP checksums on or off
 *
 * \hideinitializer
 */
#define UIP_CONF_UDP_CHECKSUMS  1

/**
 * UDP Broadcast (receive) on or off
 * (see uipethernet-conf.h)
 * \hideinitializer
 * #define UIP_CONF_BROADCAST    1
 */

/**
 * UIP statistics on or off
 *
 * \hideinitializer
 */
#define UIP_CONF_STATISTICS 0

// SLIP

//#define UIP_CONF_LLH_LEN 0
typedef void*   uip_tcp_appstate_t;

void            uipclient_appcall(void);

#define UIP_APPCALL uipclient_appcall

typedef void*   uip_udp_appstate_t;

void            uipudp_appcall(void);

#define UIP_UDP_APPCALL uipudp_appcall

#define CC_REGISTER_ARG register

#define UIP_ARCH_CHKSUM 1
#endif /* __UIP_CONF_H__ */
