#include "mbed.h"

SPI spi(p11, p12, p13); // mosi, miso, sclk
DigitalOut temp_cs(p8); // chip select
DigitalOut led1(LED1); //debug led
Serial pc(USBTX, USBRX); // tx, rx

int main() {
    float temp = 0;
    temp_cs = 1;
    
    temp_cs = 0;
    spi.format(8,3); //falling edge, clock idle high
    spi.frequency(5000000);
    spi.write(0x08); //write to config register
    spi.write(0x10); //contin conversion mode
    temp_cs = 1;

    temp_cs = 0;
    spi.write(0x54); //contin read mode
    temp_cs = 1;

    spi.format(16,3);
    while (1) {
        led1 = 0;
        temp_cs = 0;
        temp = spi.write(0x0000); //write 16 dummy bits to read 16 bits
        temp_cs = 1;
        if (temp<0)
            temp = (temp -32768)/128; //negative temp calculation
        else
            temp = temp/128;//div by 128 16bit positive temp
        led1 = 1;
        pc.printf("Temperature = %1.6f \r", temp);  
        wait(1);
    }

}