
#include "mbed.h"
#include "USBKeyboard.h"  

#define DATA_PIN P0_9
#define TOUCH_N     2
#define ANALOG_PHOTO P0_16
#define ANALOG_POTENTIOMETER P0_22
#define ANALOG_BUZZER P0_8
#define DIGITAL_CIRCLE P0_12
#define THRESHOLD   2

PinName       touch_pin[] = {P0_14, P0_12};
DigitalInOut *p_touch_io[TOUCH_N];

AnalogIn   ain(ANALOG_POTENTIOMETER);
Ticker tick;

uint8_t       key_map[] = {'1', '2', '3', '4', '5', '6', '7', '8', '8','\n'};
uint16_t touch_data[TOUCH_N] = {0, };

// Virtual serial port over USB
USBKeyboard keyboard;

// Pushbutton
DigitalIn pushbutton(P0_23);

void detect(void)
{
    for (int i = 0; i < TOUCH_N; i++) {
        uint8_t count = 0;
        DigitalInOut *touch_io = p_touch_io[i];
        
        touch_io->input();
        touch_data[i] <<= 1;
        while (touch_io->read()) {
            count++;
            if (count > THRESHOLD) {
                touch_data[i] |= 0x01;
                break;
            }
        }
        touch_io->output();
        touch_io->write(1);
        
        if (0x01 == touch_data[i]) {            // Threshold, get a touch
            keyboard.putc(key_map[i]);
        } else if (0x80 == touch_data[i]) {     // Last 7 measurement is under the threshold, touch is released
        }
    }
}

int main()
{
    // Turn off miniblip buzzer
    PwmOut speaker(P0_8);
    speaker=0.0;
    
      for (int i = 0; i < TOUCH_N; i++) {
        p_touch_io[i] = new DigitalInOut(touch_pin[i]);
        p_touch_io[i]->mode(PullDown);
        p_touch_io[i]->output();
        p_touch_io[i]->write(1);
    }
    
    tick.attach(detect, 1.0 / 40.0);
    
    // Create a temporary DigitalIn so we can configure the pull-down resistor.
    DigitalIn(DATA_PIN, PullDown);
    
    int OldPos = ain.read() * 15.0f;

    while (1) {
        // Read Pot
        int posJoy = ain.read() * 15.0f;   
        if (posJoy!=OldPos) {
            OldPos=posJoy;
            keyboard.putc(posJoy+65);
        }
        if(pushbutton) {
            keyboard.printf("!");
            while (pushbutton) {wait_ms(10);}
        }

        
    }
}