// miniblip play sound - capacitative + keyboard out

#include "mbed.h"
#include "USBKeyboard.h"      

#define THRESHOLD   2
#define TOUCH_N     5

Ticker tick;
USBKeyboard keyboard;

uint8_t       key_map[] = {'a', 'f', 'd', 'g', 'd', 'h', 'j', 'k', 'l', ';', '\'', '\n'};
PinName       touch_pin[] = {P0_15, P0_14, P0_13, P0_12, P0_11};
DigitalInOut *p_touch_io[TOUCH_N];

uint16_t touch_data[TOUCH_N] = {0, };

void detect(void)
{
    for (int i = 0; i < TOUCH_N; i++) {
        uint8_t count = 0;
        DigitalInOut *touch_io = p_touch_io[i];
        
        touch_io->input();
        touch_data[i] <<= 1;
        while (touch_io->read()) {
            count++;
            if (count > THRESHOLD) {
                touch_data[i] |= 0x01;
                break;
            }
        }
        touch_io->output();
        touch_io->write(1);
        
        if (0x01 == touch_data[i]) {            // Threshold, get a touch
            keyboard.putc(key_map[i]);
        } else if (0x80 == touch_data[i]) {     // Last 7 measurement is under the threshold, touch is released
        }
    }
}

int main()
{
    // setup
    
    // Turn off miniblip buzzer
    PwmOut speaker(P0_8);
    speaker=0.0;
    
    for (int i = 0; i < TOUCH_N; i++) {
        p_touch_io[i] = new DigitalInOut(touch_pin[i]);
        p_touch_io[i]->mode(PullDown);
        p_touch_io[i]->output();
        p_touch_io[i]->write(1);
    }
    
    tick.attach(detect, 1.0 / 40.0);
    
    while(1) {
        // do something
        wait(1);
    }
}
