// miniblip USB Mouse

#include "mbed.h"
#include "USBMouse.h"
#include <stdlib.h>
#include <math.h>
 
#define DELAY_TO_NEXT_RADIUS    (rand() % 5 + 1)
#define DELAY_TO_RESTART        (rand() % 30 + 1)
 
USBMouse mouse;

DigitalOut myled(P0_7);
myled = 0;

main()
{
    // Turn off miniblip buzzer
    PwmOut speaker(P0_8);
    speaker=0.0;
    static const float DELAY_TO_START = 25.0;
    float DELAY_TO_NEXT_POINT = 0.001;
    static const int16_t RADIUS_INC = 2;
    static const int16_t ANGLE_INC = 2;
    static const int8_t NUM_CIRCLE_SIZES = 4;
    
    int16_t x = 0;
    int16_t y = 0;  
    int16_t angle = 0;
    int16_t radius = 5; 
    int16_t recenter_radius_correction = 0;
    
    int8_t circle_count;
    
    int nextPointFrequency;
    
    for (circle_count = 1; circle_count <= 5; circle_count++)
    {
        while (angle <= 360)
        {
            x = cos((double)angle*3.14/180.0)*5;
            y = sin((double)angle*3.14/180.0)*5;
            mouse.move(x, y);
            angle += ANGLE_INC;
            wait(.001);
        }
            
        wait(.25);
        x = y = angle = 0; 
    }
 
    wait(DELAY_TO_START);
    
    while (true)
    {
        for (circle_count = 1; circle_count <= NUM_CIRCLE_SIZES; circle_count++)
        {
            while (angle <= 360)
            {
                x = cos((double)angle*3.14/180.0)*radius;
                y = sin((double)angle*3.14/180.0)*radius;
                mouse.move(x, y);
                recenter_radius_correction -= x;
                angle += ANGLE_INC;
                wait(DELAY_TO_NEXT_POINT);
            }
            
            nextPointFrequency = rand() % 1000 + 1;
            
            if(nextPointFrequency < 100)
                nextPointFrequency = 100;
                
            DELAY_TO_NEXT_POINT = 1/(float)nextPointFrequency; 
            
            wait(DELAY_TO_NEXT_RADIUS);
            x = y = angle = 0; 
            radius += RADIUS_INC;
            mouse.move(recenter_radius_correction,0);
            recenter_radius_correction = 0;
        }
        
        radius = 5;   
        wait(DELAY_TO_RESTART);
    }
}
