/**********************************************************************************************
 Copyright (c) 2014 DisplayModule. All rights reserved.

 Redistribution and use of this source code, part of this source code or any compiled binary
 based on this source code is permitted as long as the above copyright notice and following
 disclaimer is retained.

 DISCLAIMER:
 THIS SOFTWARE IS SUPPLIED "AS IS" WITHOUT ANY WARRANTIES AND SUPPORT. DISPLAYMODULE ASSUMES
 NO RESPONSIBILITY OR LIABILITY FOR THE USE OF THE SOFTWARE.
 ********************************************************************************************/

/******************************************************************************
 * Tested on NUCLEO-F401RE, LPCXpresso11U68, LPCXpresso824-MAX platform.
 *****************************************************************************/

#include "mbed.h"

#include "DmTftHX8353C.h"
#include "DmTftS6D0164.h"
#include "DmTftIli9325.h"
#include "DmTftIli9341.h"
#include "DmTftSsd2119.h"
#include "DmTftRa8875.h"
#include "DmTouch.h"
#include "DmTpFt6x06.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

/* Note that there are restrictions on which platforms that can use printf
   in combinations with the DmTftLibrary. Some platforms (e.g. LPC1549 LPCXpresso)
   use the same pins for USBRX/USBTX and display control. Printing will
   cause the display to not work. Read more about this on the display's notebook
   page. */
//#define log(...) printf(__VA_ARGS__)
#define log(...)

#if 1
  /* Displays without adapter */
  #define DM_PIN_SPI_MOSI   D11
  #define DM_PIN_SPI_MISO   D12
  #define DM_PIN_SPI_SCLK   D13
  #define DM_PIN_CS_TOUCH   D4
  #define DM_PIN_CS_TFT     D10
  #define DM_PIN_CS_SDCARD  D8
  #define DM_PIN_CS_FLASH   D6
#else
  /* Displays with adapter */
  #define DM_PIN_SPI_MOSI   A0
  #define DM_PIN_SPI_MISO   D9
  #define DM_PIN_SPI_SCLK   A1
  #define DM_PIN_CS_TOUCH   D8
  #define DM_PIN_CS_TFT     A3
  #define DM_PIN_CS_SDCARD  D10
#endif

/******************************************************************************
 * Local variables
 *****************************************************************************/
 
/*********  TFT DISPLAY INIT *********/
//DmTftIli9325 tft(A4, A3, A5, A2);  /* DmTftIli9325(PinName wr, PinName cs, PinName dc, PinName rst) DM_TFT28_103 and DM_TFT24_104 */
DmTftIli9341 tft(D10, D9, D11, D12, D13);  /* DmTftIli9341(PinName cs, PinName dc, PinName mosi, PinName miso, PinName clk)  DM_TFT28_105 and DM_TFT28_116*/
//DmTftSsd2119 tft(D10, D9, D11, D12, D13);  /* DmTftSsd2119(PinName cs, PinName dc, PinName mosi, PinName miso, PinName clk) DM_TFT35_107 */
//DmTftRa8875  tft(D10, D9, D11, D12, D13);  /* DmTftRa8875(PinName cs, PinName sel, PinName mosi, PinName miso, PinName clk) DM_TFT43_108 and DM_TFT50_111   For DmTftRa8875 driver, The panel resolution should be config in DmTftRa8875::init() function on the DmTftRa8875.cpp file. */

 /*********   TOUCH PANEL INIT  *********/
//DmTouch touch(DmTouch::DM_TFT28_103);
//DmTouch touch(DmTouch::DM_TFT24_104);
DmTouch touch(DmTouch::DM_TFT28_105, D11, D12, D13);
/* DM-TFT28-116  */
//I2C i2c(D14, D15);  
//DmTpFt6x06 touch(DmTpFt6x06::DM_TFT28_116, i2c); 
//DmTouch touch(DmTouch::DM_TFT35_107, D11, D12, D13);
//DmTouch touch(DmTouch::DM_TFT43_108, D11, D12, D13);  // For DmTftRa8875 driver, The panel resolution should be config in DmTftRa8875::init() function on the DmTftRa8875.cpp file.
//DmTouch touch(DmTouch::DM_TFT50_111);


DigitalInOut csTouch(DM_PIN_CS_TOUCH, PIN_OUTPUT, PullUp, 1);
DigitalInOut csDisplay(DM_PIN_CS_TFT, PIN_OUTPUT, PullUp, 1);
DigitalInOut csSDCard(DM_PIN_CS_SDCARD, PIN_OUTPUT, PullUp, 1);
#ifdef DM_PIN_CS_FLASH
  DigitalInOut csFlash(DM_PIN_CS_FLASH, PIN_OUTPUT, PullUp, 1);
#endif

/******************************************************************************
 * Global variables
 *****************************************************************************/

/******************************************************************************
 * Local functions
 *****************************************************************************/


/******************************************************************************
 * Main
 *****************************************************************************/

int main() {
  log("init tft \r\n");
  tft.init();
  
  uint16_t x = 0;
  uint16_t y = 0;
  uint16_t w = tft.width();
  uint16_t h = tft.height();
  
  bool down = false;
  bool lastDown = false;
  
  tft.drawString(20, 20, "x:");
  tft.drawString(100, 20, "y:");

  touch.init();
  while (1) {
   touch.readTouchData(x, y, down);
    if (down) {
      tft.drawNumber(40, 20, x, 5, false);
      tft.drawNumber(120, 20, y, 5, false);
      tft.drawPoint(x, y, 1);
    } else if (lastDown) {
      // no longer pressed, clean text
      tft.drawString(40, 20, "     ");
      tft.drawString(120, 20, "     ");
    }
    wait(0.040);
    lastDown = down;
  }

}
