/**********************************************************************************************
 Copyright (c) 2014 DisplayModule. All rights reserved.

 Redistribution and use of this source code, part of this source code or any compiled binary
 based on this source code is permitted as long as the above copyright notice and following
 disclaimer is retained.

 DISCLAIMER:
 THIS SOFTWARE IS SUPPLIED "AS IS" WITHOUT ANY WARRANTIES AND SUPPORT. DISPLAYMODULE ASSUMES
 NO RESPONSIBILITY OR LIABILITY FOR THE USE OF THE SOFTWARE.
 ********************************************************************************************/

#ifndef Canvas_h
#define Canvas_h

#include "DmTftBase.h"

class Canvas
{
public:

  Canvas(uint16_t x, uint16_t y, uint16_t width, uint16_t height, uint16_t fg = WHITE, uint16_t bg = BLACK, uint16_t borderWidth = 0, uint16_t borderColor = WHITE);

  bool isInside(uint16_t x, uint16_t y) { return (x >= _x) && (y >= _y) && (x <= (_x+_width)) && (y <= (_y+_height)); }
    
  void setColors(uint16_t foreground, uint16_t background) { _fgColor = foreground; _bgColor = background; }
  
  void setBorder(uint16_t width, uint16_t color);
  
  void enableBorder(bool enable);

  void draw(DmTftBase* tft);
  void drawString(DmTftBase* tft, const char* msg);
  
  uint16_t x() { return _x; }
  uint16_t y() { return _y; }
  uint16_t width() { return _width; }
  uint16_t height() { return _height; }

private:

  uint16_t _x, _y, _width, _height, _borderWidth;
  uint16_t _fgColor, _bgColor, _borderColor;
  bool _borderEnabled;
};
#endif



