/**********************************************************************************************
 Copyright (c) 2014 DisplayModule. All rights reserved.

 Redistribution and use of this source code, part of this source code or any compiled binary
 based on this source code is permitted as long as the above copyright notice and following
 disclaimer is retained.

 DISCLAIMER:
 THIS SOFTWARE IS SUPPLIED "AS IS" WITHOUT ANY WARRANTIES AND SUPPORT. DISPLAYMODULE ASSUMES
 NO RESPONSIBILITY OR LIABILITY FOR THE USE OF THE SOFTWARE.
 ********************************************************************************************/

#include "Canvas.h"

Canvas::Canvas(uint16_t x, uint16_t y, uint16_t width, uint16_t height, uint16_t fg, uint16_t bg, uint16_t borderWidth, uint16_t borderColor) :
  _x(x), _y(y), _width(width), _height(height), _borderWidth(borderWidth), _fgColor(fg), _bgColor(bg), _borderColor(borderColor)
{
  _borderEnabled = _borderWidth > 0;
}

void Canvas::setBorder(uint16_t width, uint16_t color)
{
  _borderWidth = width;
  _borderColor = color;
  _borderEnabled = _borderWidth > 0;
}

void Canvas::enableBorder(bool enable)
{
  _borderEnabled = enable;
}

void Canvas::draw(DmTftBase* tft)
{
  tft->fillRectangle(_x, _y, _x+_width, _y+_height, _bgColor);
  if (_borderEnabled) {
    for (int i = 0; i < _borderWidth; i++) {
      tft->drawRectangle(_x+i, _y+i, _x+_width-i, _y+_height-i, _borderColor);
    }
  }
}

void Canvas::drawString(DmTftBase* tft, const char* msg)
{
  tft->drawStringCentered(_x, _y, _width, _height, msg);
}

