/** ECG ADS1291 Test program.
ADS1291 is a single channel ECG chip
with a 24 bit Sigma-Delta ADC
 */
 
#include "mbed.h"
#include <string.h>
#include <stdio.h>
#include "ds3231.h"
#include "SDFileSystem.h"
#include "ecg_dec.h"
#include "rtc.h"
#include "sdcard.h"
#include "ec_bp.h"

#include "struct.h"  // Added on 31/5/17_Nidhin
//#include "test_type.h" //Added on  31/5/17_Nidhin
FILE *fpeecg1; // FILE pointer to ECG file
Serial pc(USBTX,USBRX);  


uint16_t ecg(int32_t pid) 
//float ecg(int pid) 
 {
    
    uint8_t lead_reg=0;      // added on 14/06 to check lead -off 
    //----------------------- Structure for Bluetooth  Added Nidhin 1/6/2017-------------------//
    
    //BLUETOOTH STRUCTURE
    
    BLEMsg_info *ptr_BLEMsg_info_ecg, BLEMsg_info_ecg; // A copy of master strcuture [ "BLEMsg_info" ] by name "BLEMsg_info_ecg" is created
    ptr_BLEMsg_info_ecg = &BLEMsg_info_ecg;            // *ptr_BLEMsg_info_bp is the pointer to local copy;
    
    // Declaration of Date Structure
    DateTime_info *ptr_DateTime_info_ecg, DateTime_info_ecg; // A copy of Master Structure "DateTime_info" created, 
    ptr_DateTime_info_ecg = &DateTime_info_ecg;             // Structure pointer points to that copy.
    
    
    // RTC operations
    time_t epoch_time_ecg;           //A copy of time_t by name  epoch_time_bp is created 
    epoch_time_ecg = rtc_read();    // time is got from get epoch function.  
    
    struct tm * ptr_time_info_ecg, time_info_ecg;   // Sturucture copy of tm is created
    ptr_time_info_ecg = localtime(&epoch_time_ecg); // Structure accepts the time in local format from "time_t" type.
      
    //BELOW LINE IS TO CHECK Date and TIME 
    //pc.printf("Time is %d: %d: %d\n", (*ptr_time_info_ecg).tm_hour, (*ptr_time_info_ecg).tm_min, (*ptr_time_info_ecg).tm_sec);
    //pc.printf("Date is %d:%d:%d\n", (*ptr_time_info_ecg).tm_mday, (*ptr_time_info_ecg).tm_mon+1, (*ptr_time_info_ecg).tm_year-100);
    
    //Copying from one structure to the other using variables
    DateTime_info_ecg.hour = (uint8_t)(*ptr_time_info_ecg).tm_hour;
    DateTime_info_ecg.mins = (uint8_t)(*ptr_time_info_ecg).tm_min;
    DateTime_info_ecg.sec =  (uint8_t)(*ptr_time_info_ecg).tm_sec;
    
    DateTime_info_ecg.date = (uint8_t) (*ptr_time_info_ecg).tm_mday;
    DateTime_info_ecg.month =(uint8_t)(*ptr_time_info_ecg).tm_mon+1;
    DateTime_info_ecg.year = (uint8_t)(*ptr_time_info_ecg).tm_year-100;
    
    // Copying Time to Main structure
    BLEMsg_info_ecg.date_time.hour = DateTime_info_ecg.hour;
    BLEMsg_info_ecg.date_time.mins = DateTime_info_ecg.mins;
    BLEMsg_info_ecg.date_time.sec = DateTime_info_ecg.sec;
    
    BLEMsg_info_ecg.date_time.date = DateTime_info_ecg.date ;
    BLEMsg_info_ecg.date_time.month = DateTime_info_ecg.month ;
    BLEMsg_info_ecg.date_time.year =  DateTime_info_ecg.year ;
    
    
    //Checking if the structure has these values    
    //pc.printf("Time 2 is %d:%d:%d\n", DateTime_info_ecg.hour, DateTime_info_ecg.mins, DateTime_info_ecg.sec);
    //pc.printf("\t Date is %d:%d:%d\n",DateTime_info_ecg.date, DateTime_info_ecg.month, DateTime_info_ecg.year);
    
    
    //Loading values to of Test type
    test_type_info test_type_info_ecg;  // copy of " test_type_info" created  
    test_type_info_ecg = ECG_Test;       // Loaded value 00 to the test type 
    
    BLEMsg_info_ecg.test_type = test_type_info_ecg;
    //Check if 00 is getting printed
    //pc.printf("Test Type is : %d\n", test_type_info_ecg);
    
    
    // Loading values of Length ,  PID, DID, sampling frequency, number of samples, calculated data.
    BLEMsg_info_ecg.device_id = 01;                   // Device ID fixed
    BLEMsg_info_ecg.patient_id = (uint32_t)pid;       // Patient ID
    BLEMsg_info_ecg.sampling_freq = 500;              // sampling frrquency
    BLEMsg_info_ecg.length = 4022;                   //Total length of data in bytes  22 B+ 4000 data
    
    /*
    //Loading number of samples
    NumSamples_info NumSamples_info_bp;              //Copy of structure NumSamples_info
    NumSamples_info_bp.num_ppg_sample = 1664;        // PPG & ECG Sample number loaded in structure copy
    NumSamples_info_bp.num_ecg_sample = 1024;
    */
    
    BLEMsg_info_ecg.num_samples.num_sample_ppg_dummy =  0 ;// PPG  number of samples copied to master struct 
    BLEMsg_info_ecg.num_samples.num_sample_ecg_OTtyp =  1000 ; // ECG  number of samples copied to master struct
    
    //----------------------------------------END Structure for Bluetooth - Added Nidhin 1/6/2017-------

     uint32_t concatenate_value2 = 0;      // ORG. "int concatenate_value2 = 0;" Nidhin 1/6/17
    uint32_t *ecg_ptr;                   // Added 1/6/2017 Nidhin
    ecg_ptr = &concatenate_value2; // Pointer to pass for ECG write into SD card Nidhin 1/6/2017
    
    uint16_t count = 0; 
    uint16_t fs = 500;
    //uint32_t ecg_buf[N_ECG];
    Timer t;
    
    //------------------ Declaration for Peak value detection ------------------------------------
  uint32_t ecg_samp1[1] ; uint32_t ecg_samp2[1]; uint32_t ecg_samp3[1];  // Buff 12 &3 Stores sample 1, 2 & 10th sample
  uint32_t fppos;  // Variable to hold pointer position
  uint32_t hi_val;
  uint32_t pk_val[20];
  uint16_t pk_pos[20]={0};
 // unsigned int a; //uint32_t pk=0;
  int32_t hi_dif = 0; //diff between high value and it's consecutive value
  uint16_t j=0; // int count1 = N_ECG/fs, a_dif=0, fs1 = fs ,h=0;
  int32_t m =0;       // Variable to move the file pointer in fseek fun
  int32_t samp_10 = 28;       // Variable to move to 10th sampple from current
  char buffer3[32];
  
    // ------------------------- Declaration for Heart Rate calculation --------------------------
 uint8_t n=0; 
 float pos_dif, HR[10], HR1,t_pos_dif;
 uint8_t t_sec = 60; 
 float HR_sum = 0,HR_avg;
    // -------------------------------------------------------------------------------------------
  //  unsigned char chk = 1;
    pc.baud(baud_rate);
    freqset();               // setting the frequency
    setupfunc();    
    //ecgtestsetupfunc();          // For test set up of 1Hz square wave signal
   lead_reg= ecgsetupfunc();
 //   chk = 1;
 
 
   //ORIGINAL sd_open_ECGfile(pid);        // opening the ecg file  COMMENTED Nidhin 1/6/2017
 if (lead_reg==0)                    // checking for proper lead contact// 14/06
 {  
   sd_open_ECGfilee(pid);  // REPLACED Nidhin 1/6/2017 Nidhin 
   
  pc.printf( "Raw data is = \n"); 
  
 for(int i=0; i<N_ECG; i++)
   {
     concatenate_value2= readvalue();
     pc.printf( "%d\n", concatenate_value2); //ADDED Nidhin 21/6/2017
     
     sd_ecgwrite(ecg_ptr); // REPLACED Nidhin 1/6/2017
     
   } 
  
   //sd_close();          // closing the file COMMENTED Nidhin 1/6/2017
    sd_close_ecg();          // closing the ECG file REPLACED Nidhin 1/6/2017 Nidhin
    
    
/*   
 // ---------- reading back SD data for processing --------------------
 sd_read_file(15);
 printf("Reading back SD data\n");
 for(int i=10;i<N_ECG;i++)
 {
 ecg_buf= sd_read();
 //printf("%d\n",ecg_buf[i]);
 }
 
  sd_close();    */
 

 //----------------------------- PEAK DETECTION AND HEART RATE CALCULATION ---------------------------------------------------
 
 // -------------------------------------- PEAK DETECTION -------------------------------------------------------------
 // ----------------------------------------- Main loop --------------------------------------------------
 
 sprintf(buffer3, "/sd/%d_ECG.csv", pid);    // For opening a specific file    
 fpeecg1 = fopen(buffer3, "r");
 
for(uint16_t i=0;i<(N_ECG-10);i++){
    count++;
rewind(fpeecg1);               // Go to start of file each time
fseek(fpeecg1, m, SEEK_CUR);   // Update the count value according to move pointer //// after every calc. the pointer moves to 0th position, as we have used fseek, hence to make it jump to the respective position by "m" bytes this command is used
fread(ecg_samp1, sizeof(uint32_t), 1, fpeecg1);  // Read sample 1
fread(ecg_samp2, sizeof(uint32_t), 1, fpeecg1);  // Read Sample 2
fseek(fpeecg1, samp_10, SEEK_CUR);   // Moving to tenth sample
fread(ecg_samp3, sizeof(uint32_t), 1, fpeecg1);  // Read 3rd sample
//pc.printf("ecg_samp1 = %d , ecg_samp2 = %d, ecg_samp3 = %d\n",ecg_samp1[0],ecg_samp2[0],ecg_samp3[0] ); //Test  Value held by buffer each round


if(ecg_samp1[0]>ecg_samp2[0])
{
hi_val = ecg_samp1[0]; //To find the high value
//printf("high value= %d\n",hi_val);
//a = i;
//printf("a= %d\n",a);
hi_dif = hi_val-ecg_samp3[0];

  // ---------------------------- If hi_val is greater than next ten input values, then compare the hi_val with the tenth input value. 
  //     If the diff is greater than 10000, then it is a valid peak (pls chk the below condition)-------------------------------------
  //   if((hi_dif > 10000) && ((a+10) < N_ECG))
    if(hi_dif > 10000)
    {
   //  if(a_dif <= 0) ------------------------ add this condition if needed ----------------------
   //  {
     pk_val[j] = hi_val; //if condition satisfied, put the "pk" value into "pk_val" buffer
     pc.printf("peak value= %d\n",pk_val[j]);
     pk_pos[j]=i; // also save the peak's position
     pc.printf("peak position is = %d\n",pk_pos[j]);
     i = i+120;  // once confirmed that this is the necessary peak, skip the next 120 input values
     n = j; // where n is the number of peaks detected
     j = j+1;
     m = m + 480; //similar reason to considering 28, but to skip 120 samples. this cond. is satisfied only when we hit a peak - suhasini_26thjune17
     
  //   printf("j after peak detection is= %d\n",j);
  //   }
     }
     
    else
    {
     m = m+4; // this is when we do not hit a peak and have to continue searching thru, hence move to the next sample and not skip 120 samples- - suhasini_26thjune17
    }
     // store the peak value position in "pk_pos" 
}
else
{
m = m+4;
}
//pc.printf("i=%d",i);
}
n=n+1;
pc.printf("n=%d\n",n);

 // ----------------- HEART RATE LOGIC --------------------------- 
 
 for(uint16_t i = 0;i < n-1;i++)
 {
  pos_dif = pk_pos[i+1] - pk_pos[i];                 // difference between two consequtive peaks
  pc.printf("peak position diff is = %f\n",pos_dif);
  //printf("peak position i value is = %d\n",i);
  t_pos_dif = pos_dif/fs;                           // sample difference between peak positions divided by sampling frequency gives the difference value in terms of actual time
  pc.printf("time in seconds is = %f\n",t_pos_dif);
  HR[i] = t_sec/t_pos_dif;                          //HR calculation
  pc.printf("Heart Rate is = %f\n",HR[i]);
 // n = i;
  HR1 = HR[0];
 }
 
 
 // ---------------------- To average individual HRs for higher number of samples -----------------------
 for(uint16_t i = 0;i < n-1;i++)
 {
 HR_sum = HR[i]+HR_sum; 
 }
 HR_avg = HR_sum/(n-1); // To find average of all the individual HRs calculated
 printf("Heart Rate sum is = %f\n",HR_sum);
 //printf("Denominator = %d\n",n);
 printf("Heart Rate avg is = %f\n",HR_avg);
 
 fclose(fpeecg1);
 pc.printf("temporary file closed\n"); 
BLEMsg_info_ecg.cal_data.cal_sbp_dummy = 0;
BLEMsg_info_ecg.cal_data.cal_dbp_OTtyp = HR1;  //To be modified after HR code is added. 

structure_file(ptr_BLEMsg_info_ecg, pid); //copy the ECG structure to Main file  //COMMENTED Nidhin 10/6/2017 
ecgfile_mainfile(pid);                        // copy raw data to the main file and ECG file is cleared. //COMMENTED Nidhin 10/6/2017

pc.printf("Closed the main file\n");
 
 
 
  //return HR1;
 return HR_avg; 
  
}          
 else 
     {
        pc.printf("no - leadoff");
        return 0;
    } 
pc.printf("closing temporary file\n");
 // fclose(fpeecg1);
//  pc.printf("temporary file closed\n");
}   // End of main function
