
#include "mbed.h"
#include "sdcard.h"
#include "struct.h"
#define ACK 0x00                 /// changed //16/06 #define all the values removing structure 
#define start_of_file 0x01
#define end_of_file 0x02
#define data_trfr 0x03
#define NACK 0xFF
#define sos 0xc0
#define eos 0xc0
#define no_of_samples 1500
#include "eeprom_pgm.h"
//#define len 6000

BLEMsg_info *bt_file;
Point *myBleMsg;

Serial mc(USBTX,USBRX);                  // serial terminal
Serial blue(PA_2,PA_3);                 // communicating bluetooth through serial 
                 
static uint32_t total_samples=0;              // variable to hold total number of samples
uint8_t ack_rx;                        // varibale to receive ack from the bluetooth 
Point b;                               // structure copy
BLEMsg_info bt_file1;                  // structure copy
static uint32_t total_file_size=0;        // to determine the size of the file 
static uint32_t total_file_read=0; 
static uint32_t file_start=0;           // variable for 'for loop'
static uint32_t j=0;
uint8_t count_send=0; 
static uint32_t file_pointer_position=0;
static int32_t bt_file_tosend=0;           // file to send on bluetooth
static int32_t current_file=0;            // file of the test done for the current pid 
static uint32_t counter=0;
uint8_t file=0;


uint8_t bt_send(uint8_t state_tx)
{
  uint32_t v1[no_of_samples];    
  blue.baud(115200);                  // baud rate of bluetooth
  bt_file=&bt_file1;                      
  myBleMsg=&b; 
  int8_t check_sum=0;
  uint8_t state_rx =0;
 
  

  

    switch(state_tx)
          {
 
       case 1:    
                  //blue.printf("\n");
                   state_tx =0; 
                  counter=0;
                  total_file_read=0; 
                  file_start=0;          
                  j=0; count_send=0;  total_samples=0;  
                  file_pointer_position=0;
                  bt_file_tosend=eprom_read(6);            // reading the file number(pid) from eeprom which has to be sent to bluetooth
                  current_file=eprom_read(1);  
                  bt_file_tosend=bt_file_tosend+1;
                  eprom_write(6,bt_file_tosend);            // read the current pid 
                  mc.printf("eeprom file=%d",bt_file_tosend);  
                  mc.printf("currentfile=%d",current_file);  
                  if (bt_file_tosend>current_file)       // if the file sent to bluetooth and current file are same,
                  {                                       // then there is no new file to send
                      state_rx =6;
                      }
                  else
                    {
                       file=sd_open_read(bt_file_tosend);
                       if(file==0)
                        {
                           state_tx =6; 
                           }
                         else 
                         {   
                            sendinit(); 
                            total_file_size=file_size() ;             // determined the file size  
                            state_rx =1;
                            blue.printf("\n"); 
                         }
                        }
                                     
                    break;
               
                   
       case 2:   total_samples=0;   
                 sd_read1(bt_file1);               // read the sd card file
                 myBleMsg->bt_msg=bt_file1;         //copy the contents to the structure
                 send();                                // send the initial string
                 blue.printf("\n");                       
                 total_samples= myBleMsg->bt_msg.num_samples.num_sample_ppg_dummy+myBleMsg->bt_msg.num_samples.num_sample_ecg_OTtyp;
                 
                 state_tx =0;
                 state_rx =2;
                 count_send=0;
                 total_file_read=file_size1();
                 break;                 
 
 
       case 3:     counter=0;
                if(count_send<(total_samples/no_of_samples))
                  {
                     sd_read(v1,no_of_samples);      
                     counter=j+no_of_samples;               //read 1500 samples
                     send_data_str1(); 
                     for(file_start=j;file_start<(j+no_of_samples);file_start++)
                         {     
                       
                             blue.printf("%08x", v1[file_start]);
                           
                         }
                         
                         
                          check_sum=checksum(v1);               // calculating checksum
                          state_tx =0;
                          state_rx =3;
                          send_data_str2(check_sum);            // send the remaining part of the string
                  
                   }
               
               else 
                     {
                        for(int l=0;l<no_of_samples;l++)
                          {    
                            v1[l]=NULL;
                           }
                            counter=(total_samples-( no_of_samples*count_send));
                            send_data_str1();
                            sd_read(v1,(total_samples-( no_of_samples*count_send)));
                        for(file_start=j;file_start<(total_samples-( no_of_samples*count_send));file_start++)
                          {     
                             blue.printf("%08x", v1[file_start]);
                            
                           }
                                                                   
                          state_tx=0;
                          state_rx=4;
                          send_data_str2(check_sum);
                    }   
                     
                       total_file_read=file_size1();
                        blue.printf("\n");  
                  break;        
               
         
        case 4:   total_file_read=file_size1();
                 if(total_file_read==total_file_size)          // if the total file size is same as total file size
                     {                                         // then there is no more data to send in that particular file
                    
                        state_rx=6;
                        sendlast();
                        blue.printf("\n"); 
                      //  sd_close();
                     }
                else   
                       {
                         state_rx=5;
                         total_file_read=file_size1();        
                        }   
                       
   


         }

   return state_rx;     
        
  }           
 
 
 
 
uint8_t bt_receive (uint8_t state_rx)
{
       
 unsigned char state_tx =1;      //state for transmitting 
            
Timer t;                               // timer 
uint8_t ack_rx;                        // varibale to receive ack from the bluetooth 
//Point b;                               // structure copy                     
//myBleMsg=&b;
t.start();                             // timer start
uint8_t sos_rx=0;              // sos received from app
uint8_t eos_rx=0;              // eos received from app
uint8_t chksum_rx=0;          // check sum received from app


     switch(state_rx)
         {
                
          case 1:                                       // wait for the ack
                      state_rx=0;
                      myBleMsg->proto=ACK;
                      blue.scanf("%02x%02x%08x%02x",&sos_rx,&ack_rx,&eos_rx,&chksum_rx);
            
                   if (ack_rx==myBleMsg->proto)
                     {
                       
                       state_tx=2;
                      }
                    
                    else 
                    
                      { 
                       
                        state_tx=1;
                        sd_close();
                      }
                   break;                 
 
         case 2:      state_rx =0;                        //wait for the ack
                      myBleMsg->proto=ACK;
                
                    blue.scanf("%02x%02x%08x%02x",&sos_rx,&ack_rx,&eos_rx,&chksum_rx);
                     if (ack_rx==myBleMsg->proto)
                        {
                
                          state_tx=3;
                          file_pointer_position=total_file_read;
                        }
                    
                    else 
                    
                        { 
                      
                        state_tx=2;
                        setpos1(file_pointer_position);
             
                        }
                    //blue.scanf("%02x%02x%08x%02x",&sos_rx,&ack_rx,&eos_rx,&chksum_rx);
                    break;

                
     case 3:       
                   state_rx =0;
                   myBleMsg->proto=ACK;
                  blue.scanf("%02x%02x%08x%02x",&sos_rx,&ack_rx,&eos_rx,&chksum_rx);
                 if (ack_rx==myBleMsg->proto)
                      {
                     
                        state_tx=3;
                         count_send=count_send+1;
                       file_pointer_position=total_file_read;
                      }
                    
                  else 
                    
                      { 
                       
                        state_tx=3;
                        file_start=file_start- no_of_samples;
                        setpos1(file_pointer_position);
                      }
               
                   break;    
                                            
     case 4:       
                   state_rx =0;
                   myBleMsg->proto=ACK;
                    blue.scanf("%02x%02x%08x%02x",&sos_rx,&ack_rx,&eos_rx,&chksum_rx);
                   if (ack_rx==myBleMsg->proto)
                      {
                        state_tx=4;
                         count_send=count_send+1;
                        file_pointer_position=total_file_read;
                      }
                    
                  else 
                    
                      { 
                       
                        state_tx=3;
                        file_start=file_start- no_of_samples;
                        setpos1(file_pointer_position);
                      } 
                   break;                
                 
      case 5:      state_tx=2;
                    break;
                   
      case 6:       state_rx =0;
                   /*myBleMsg->proto=ACK;
                    blue.scanf("%02x%02x%08x%02x",&sos_rx,&ack_rx,&eos_rx,&chksum_rx);
                   if (ack_rx==myBleMsg->proto)
                      {*/
                      if (bt_file_tosend!=current_file)     
                            {      sd_close();
                                // bt_file_tosend=bt_file_tosend+1;
                                 // eprom_write(6,bt_file_tosend);
                                 // sd_open_read(bt_file_tosend);
                                 // total_file_size=file_size() ;  
                                  state_tx=1;
                                  
                                  mc.printf("next file");
                               }
                         
                          else
                              {      
                                 state_tx=0;
                                 mc.printf("out");
                             }  
                               
                   // }
                    
                 /* else 
                    
                      { 
                       
                        state_tx=4;
                       
                      } */
                  
                   break;

  }

   return state_tx;          
  }           
   
 
 
 
 
 
             
void send()                                 // function to send the structure to bluetooth
{
                myBleMsg->start_of_string=sos;
                myBleMsg->length_file=26;
                myBleMsg->proto=data_trfr;                      // data transfer mode
                blue.printf("%02x",myBleMsg->start_of_string); 
                blue.printf("%02x",myBleMsg->proto);
                blue.printf("%08x",myBleMsg->length_file);      //changed the sequence 
                blue.printf("%08x",myBleMsg->bt_msg.length); 
                blue.printf("%02x",myBleMsg->bt_msg.device_id); 
                blue.printf("%08x",myBleMsg->bt_msg.patient_id);    
                blue.printf("%02x",myBleMsg->bt_msg.date_time.date);     
                blue.printf("%02x",myBleMsg->bt_msg.date_time.month);  
                blue.printf("%02x",myBleMsg->bt_msg.date_time.year);  
                blue.printf("%02x",myBleMsg->bt_msg.date_time.hour);      
                blue.printf("%02x",myBleMsg->bt_msg.date_time.mins);  
                blue.printf("%02x",myBleMsg->bt_msg.date_time.sec);  
                blue.printf("%02x",myBleMsg->bt_msg.test_type);   
                blue.printf("%04x",myBleMsg->bt_msg.sampling_freq); 
                blue.printf("%04x",myBleMsg->bt_msg.num_samples. num_sample_ppg_dummy); 
                blue.printf("%04x",myBleMsg->bt_msg.num_samples.num_sample_ecg_OTtyp); 
                blue.printf("%04x",myBleMsg->bt_msg.cal_data.cal_sbp_dummy);   
                blue.printf("%04x",myBleMsg->bt_msg.cal_data.cal_dbp_OTtyp);   
                myBleMsg->end_of_string=eos;  
                myBleMsg->chk_sum=checksum_struct();
                blue.printf("%02x",myBleMsg->end_of_string);
                blue.printf("%02x",myBleMsg->chk_sum);
    
    }
    
void sendinit()                // function to send the initial string at the start f communication to bluetooth
{              

                uint8_t sum_init=0  ;               
                myBleMsg->start_of_string=sos;
                myBleMsg->length_file=0;
                myBleMsg->proto=start_of_file;
               //  myBleMsg->bt_msg=NULL;
                sum_init=checksum_init();
                myBleMsg->chk_sum=sum_init;
                blue.printf("%02x",myBleMsg->start_of_string);
                blue.printf("%02x",myBleMsg->proto); 
                blue.printf("%08x",myBleMsg->length_file);     // chnged
                myBleMsg->end_of_string=eos;  
                blue.printf("%02x",myBleMsg->end_of_string);
                blue.printf("%02x",myBleMsg->chk_sum);
    
    }
  
   
uint8_t checksum_init()          // function to calculate the checksum for the initial string
 {
  
  uint32_t sum=0;
  uint8_t chksum_init=0;
  sum=sos+eos+start_of_file; 
  chksum_init=sum & 0x000000FF;
  return chksum_init;
  }

uint8_t checksum_last()        // function to calculate the checksum for the last string
 {
  
  uint32_t sum=0;
  uint8_t chksum_last=0;
  sum=sos+eos+end_of_file; // changed //16/06 #define all the values removing structure 
  chksum_last=sum & 0x000000FF;
  return chksum_last;
  }    
    
 void sendlast()                 // function to send the last string to the bluetooth // which determines the end of file
{
                uint8_t sum_last=0;
                myBleMsg->start_of_string=sos;
                myBleMsg->length_file=0;
                myBleMsg->proto=end_of_file;
               //  myBleMsg->bt_msg=NULL;
                sum_last=checksum_last();
                myBleMsg->chk_sum=sum_last;
                blue.printf("%02x",myBleMsg->start_of_string);
                blue.printf("%02x",myBleMsg->proto); 
                blue.printf("%08x",myBleMsg->length_file);     // chnged
                myBleMsg->end_of_string=eos;  
                blue.printf("%02x",myBleMsg->end_of_string);
                blue.printf("%02x",myBleMsg->chk_sum);
    
    }
       
 void send_data_str1()       // function to send a part of the structure // after this raw data is sent//
   {
                 myBleMsg->start_of_string=sos;
                 myBleMsg->length_file=(counter*4);
                 myBleMsg->proto=data_trfr;
                 blue.printf("%02x",myBleMsg->start_of_string); 
                 blue.printf("%02x",myBleMsg->proto);                   // chnaged
                 blue.printf("%08x",myBleMsg->length_file);
               
    }
    
    
    
 void send_data_str2(uint8_t check_sum)          // after raw data// this last part of structure is sent
    {          
                myBleMsg->chk_sum=check_sum;
                myBleMsg->end_of_string=eos;  
                blue.printf("%02x",myBleMsg->end_of_string);
                blue.printf("%02x",myBleMsg->chk_sum);
    }
    
uint8_t checksum(uint32_t  *v1)          // this function to calculate the checksum for the raw data
{

uint32_t sum=0;
uint8_t chksum_datatrfr=0;
 
 for (int i=0;i< no_of_samples;i++)
 {
     sum=sum+v1[i];
  }
  
  sum=sos+eos+sum+counter+data_trfr;
  chksum_datatrfr=sum & 0x000000FF;
  return chksum_datatrfr;
}





uint8_t checksum_struct()         // calculating checksum for sending the file structure
{

 uint32_t sum=0;
 uint8_t chksum_struct=0;
 
  sum=myBleMsg->start_of_string+myBleMsg->proto+myBleMsg->bt_msg.length+myBleMsg->bt_msg.device_id+myBleMsg->bt_msg.date_time.date+myBleMsg->bt_msg.date_time.month+myBleMsg->bt_msg.date_time.year+myBleMsg->bt_msg.date_time.hour+myBleMsg->bt_msg.date_time.mins+myBleMsg->bt_msg.date_time.sec+myBleMsg->bt_msg.test_type+myBleMsg->bt_msg.sampling_freq+myBleMsg->bt_msg.num_samples.num_sample_ppg_dummy+myBleMsg->bt_msg.num_samples.num_sample_ecg_OTtyp+myBleMsg->bt_msg.cal_data.cal_sbp_dummy+myBleMsg->bt_msg.cal_data.cal_dbp_OTtyp+myBleMsg->end_of_string+myBleMsg->chk_sum;
  chksum_struct=sum & 0x000000FF;
  return chksum_struct;
}
