#ifndef Ontvanger_h
#define Ontvanger_h
#include "mbed.h"
#include <RF24Network.h>
#include <RF24.h>

#define nrf_CE      p9
#define nrf_CSN     p8
#define spi_SCK     p7
#define spi_MOSI    p5
#define spi_MISO    p6

#ifdef PRINT_ENABLE
    #define IF_PRINT_ENABLE(x) ({x;})
    #else
    #define IF_PRINT_ENABLE(x)
    #endif


//Identification verzender/ontvanger
const uint16_t this_node = 00;
const uint16_t other_node = 01;


//
struct payload_t {
    bool reedsensor;
    float gram;
    bool messageAvailable;
    char messageIndex;
};

enum State2 {init_state,
             testConnection_state,
             send_state,
             receive_state,
            };

enum State {State_init,
            State_tare,
            State_position,
            State_read,
            State_send,
            State_receive,
            State_calibrate
           };

struct state_Packet {
    char setState;
};


class Ontvanger
{
private:


public:
    Ontvanger();
    void update();
    bool available();
    bool write(state_Packet message);
    payload_t read();
    bool isValid();
    bool testRPD();
    void printMessage(char index);
};

#endif





