/**
    Main.cpp
    Purpose: main class

    @author Pieter Berteloot

    RF24 PINOUT:
     ---- -----
    |GND | VCC |
    |----      |
    |CE    CSN |
    |SCK   MOSI|
    |MISO  IRQ |
     ---- -----

     ---- -----
    |GND | Vout|
    |----      |
    |p9    p8  |
    |p7    p5  |
    |p6    NC  |
     ---- -----
*/
//uncommend #define PRINT_ENABLE to see informational prints
#define PRINT_ENABLE

#include "mbed.h"
#include "Ontvanger.h"

Serial pc(USBTX, USBRX);
Ontvanger receive;
Timer t;

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

char c;

State2 current_state = init_state;

void acitvateLed()
{
    t.reset();
}

void setCurrentState( State2 setState )
{
    current_state = setState;
}


State2 getCurrentState()
{
    return current_state;
}

int main()
{
    IF_PRINT_ENABLE( pc.printf("\r\nVOntvanger: \r\n");
                     pc.printf("Vtesting Radio... %d\r\n", receive.isValid());
                   );

    while(1) {
        receive.update();
        switch (current_state) {
            case init_state:
                IF_PRINT_ENABLE(pc.printf("XInit State\n\r"););
                pc.baud(9600);
                t.start();
                state_Packet packet;
                payload_t payload;
                setCurrentState(testConnection_state);
                break;
                
            case testConnection_state:
                IF_PRINT_ENABLE(pc.printf("XTesting State\n\r"););
                packet.setState = 't';
                
                if (receive.write(packet)){
                    pc.printf("VConnection test passed.\n\r");
                    setCurrentState(receive_state);
                    }
                else
                    IF_PRINT_ENABLE(pc.printf("VConnection failed, trying again...\n\r"););
                    
                wait_ms(500);
                break;

            case send_state:
                IF_PRINT_ENABLE(pc.printf("SSend State\n\r"););
                if(c == 's') {
                    IF_PRINT_ENABLE(pc.printf("VSend state: Tare\n\r"););
                    packet.setState = 's';
                }
                if (c == 'c') {
                    IF_PRINT_ENABLE(pc.printf("VSend state: Calibrate\n\r"););
                    packet.setState = 'c';
                }
                bool ok = receive.write(packet);
                if (ok)
                    IF_PRINT_ENABLE(pc.printf("Vok.\n\r"););
                else
                    IF_PRINT_ENABLE(pc.printf("Vfailed.\n\r"););
                wait(0.1);
                setCurrentState(receive_state);
                break;

            case receive_state:
                pc.printf("");//print niet weg doen, één of andere reden werkt het niet zonder
                if (receive.available()) {
                    payload_t payload;
                    payload = receive.read();
                    if(!payload.messageAvailable) {
                        pc.printf("%f\r\n", payload.gram);
                        if (payload.reedsensor) {
                            acitvateLed();
                        }
                    }
                }

                if (t.read() <= 1) {
                    myled1 = myled2 = myled3 = myled4 = 1;
                } else
                    myled1 = myled2 = myled3 = myled4 = 0;

                if(pc.readable()) {
                    c = pc.getc();
                    if(c == 's' or c == 'c')
                        setCurrentState(send_state);
                    wait(0.5);
                }
                break;
        }
    }
}