//uncommend // in #define PRINT_ENABLE to see prints
#define PRINT_ENABLE

#include "Verzender.h"

#define NUM_SAMPLES 2000        // size of sample series
#define MIN_TARE_VALUE 0.500   //2.5 / 3.3 (2.5V is  zero load and adc is between 0 and 1)µ

Verzender sent;
Serial pc(USBTX, USBRX);
Timer t1;
State current_state = State_init;
State previous_state;

InterruptIn reedSensor(D9);
AnalogIn ain(A2); 


float tare = 0;
float calibration = 0;
bool reed = false;
bool tareDone = false;
char nextState;
float calibrationMass = 1000;
float AVERAGE_TARE = 0;
float CALIBRATION_OFFSET = 0.019992;


/**
    Sets the reed status on rising trigger
*/
void setReed()
{
    reed = true;
}

/**
    resets the reed status on falling trigger
*/
void dissableReed()
{
    reed = false;
}

/**
    Sets the current status of the state machine

    @param the state to be set
*/

void setCurrentState( State setState )
{
    previous_state = current_state;
    current_state = setState;
}




/**
    Get the average of a given number of samples from the analog input

    @param amount of samples
    @return average of the analog input
*/
float getAverageSamples(int samples, int subSamples)
{
    float AVERAGE = 0;
    int num_sub_samples = 0;
    int num_samples = 0;

    while (num_samples <samples) {
        float r = ain.read();
        AVERAGE += r;
        num_samples++;
        if(num_sub_samples >= subSamples) {
            wait_ms(10);
            num_sub_samples = 0;
        }

        num_sub_samples++;
    }
    AVERAGE /= num_samples;
    num_samples = 0;

    return AVERAGE;
}


float getAverageSamples2(int samples, int subSamples)
{
    float AVERAGE = 0;
    float FinalAVERAGE = 0;
    float SUB_AVERAGE = 0;
    float SUB_AVERAGE_ARRAY[samples];
    int num_samples = 0;
    int num_subSamples = 0;
    int count = 0;

    //get average of 10 samples and store them in array
    while( num_samples < samples) {
        while (num_subSamples < subSamples) {
            float r = ain.read();
            SUB_AVERAGE += r;
            AVERAGE += r;
            num_subSamples++;
            count++;
        }
        SUB_AVERAGE /= num_subSamples;
        SUB_AVERAGE_ARRAY[num_samples] = SUB_AVERAGE;
        SUB_AVERAGE = 0;
        num_subSamples = 0;
        num_samples++;
    }
    num_samples = 0;

    //calculate total average of 2500 samples
    AVERAGE /= count;
    AVERAGE = ((tare - AVERAGE)*(calibrationMass))/(CALIBRATION_OFFSET);
    count = 0;

    //loop over array and check if the samples are within range of total average
    for (int i=0; i< samples; i++) {
        float massa = ((tare - SUB_AVERAGE_ARRAY[i])*(calibrationMass))/(CALIBRATION_OFFSET);

        if (massa < AVERAGE - 30 or massa > AVERAGE + 30) {
            massa = 0;
            count--;
        }
        FinalAVERAGE += massa;
        count++;
    }
    FinalAVERAGE /= count;
    IF_PRINT_ENABLE(pc.printf("FinalAVERAGE: %f , AVERAGE: %f, COUNT: %d\n\r", FinalAVERAGE, AVERAGE, count););
    return FinalAVERAGE;
}

/**
    Main function:
        State machine:
            Init: initialization
            Position: Checks if the paddle is on tare position
            Tare: Set Zeroload point on average of 50000 samples
            Read:   Read the mass when the paddle passes the read position and
                    send the data to the receiver.
            Receive: Check if there were messages
            Calibration: Get calibration factor
*/
int main()
{
    pc.baud(9600);
    pc.printf("--Verzender2--\n\r");
    sent.printDetails();
    sent.sendMessage(STARTUP);
    while(1) {
        reedSensor.fall(&setReed);
        reedSensor.rise(&dissableReed);
        sent.update();

        switch (current_state) {
            case State_init:
            IF_PRINT_ENABLE(pc.printf("State: Init\n\r"););
                sent.sendMessage(INIT);
                wait_ms(1000);
                reedSensor.mode(PullUp);
                setCurrentState(State_read);
                payload_t payload;
                sent.sendMessage(STARTUP_SUCCES);
                break;

            case State_position:
                sent.sendMessage(POSITION);
                IF_PRINT_ENABLE(pc.printf("State: position\n\r"););
                if (reed) {
                    sent.sendMessage(POSITION_WAIT);
                    IF_PRINT_ENABLE(pc.printf("Waiting for 5 seconds\n\r"););
                    wait(1);
                    if (reed and nextState == 's') {
                        IF_PRINT_ENABLE(pc.printf("Selecting tare state\n\r"););
                        setCurrentState(State_tare);
                        break;
                    } else if (reed and nextState == 'c') {
                        IF_PRINT_ENABLE(pc.printf("Selecting calibrate state\n\r"););
                        setCurrentState(State_calibrate);
                        break;
                    } else {
                        sent.sendMessage(POSITION_ERROR);
                        IF_PRINT_ENABLE(pc.printf("Error on position\n\r"););
                        setCurrentState(State_read);
                    }
                }
                break;


            case State_tare:
                sent.sendMessage(TARE);
                IF_PRINT_ENABLE(pc.printf("State: tare\n\r"););
                tare = getAverageSamples(250,100);
                if(MIN_TARE_VALUE <= tare) {
                    sent.sendMessage(TARE_COMPLETE);
                    IF_PRINT_ENABLE(pc.printf("tare = %f\r\n",tare*3.3););
                    tareDone = true;
                } else if (tare <= 0.01) {
                    sent.sendMessage(BATTERY);
                    IF_PRINT_ENABLE(pc.printf("ERROR: BATTERY NOT INSERTED\n\r"););
                } else {
                    sent.sendMessage(TARE_ERROR);
                    IF_PRINT_ENABLE(pc.printf("ERROR: TARE VALUE TO LOW\n\r"););
                    tareDone = false;
                }
                setCurrentState(State_read);
                break;

            case State_read:
                sent.sendMessage(READ);
                if (reed) {
                    if (tareDone == true){
                        float massa = getAverageSamples2(100, 5);
                        //payload.reedsensor = 1;
                        payload.gram = massa;
                        IF_PRINT_ENABLE(pc.printf("%f\r\n", payload.gram););
                        bool ok = sent.write(payload);
                        if (ok) {
                            IF_PRINT_ENABLE(
                            pc.printf("ok.\n\r"););
                        } else {
                            IF_PRINT_ENABLE(pc.printf("failed.\n\r"););
                        }
                    } else {
                        sent.sendMessage(TARE_FIRST);
                        IF_PRINT_ENABLE(pc.printf("Tare First.\n\r"););
                    }
                
                    setCurrentState(State_receive);
                }
                break;

            case State_receive:
                sent.update();
                if (sent.available()) {
                    IF_PRINT_ENABLE(pc.printf("Received something\n\r"););
                    state_Packet state;
                    state = sent.read();

                    if( state.setstate == 's') {
                        IF_PRINT_ENABLE(pc.printf("Next state: Tare\n\r"););
                        nextState = 's';
                        setCurrentState(State_position);
                        break;
                    }
                    if(state.setstate == 'c') {
                        IF_PRINT_ENABLE(pc.printf("Next state: Calibrate\n\r"););
                        nextState = 'c';
                        setCurrentState(State_position);
                        break;
                    }
               }

                setCurrentState(State_read);

                break;

                
                case State_calibrate:
                    setCurrentState(State_read);
                    if(tareDone == true) {
                        IF_PRINT_ENABLE(pc.printf("State: calibreren\n\r"););
                        IF_PRINT_ENABLE(pc.printf("Put 1kg on paddle...\n\r"););
                        IF_PRINT_ENABLE(pc.printf("Waiting: 10 seconds\n\r"););
                        wait(1);
                        IF_PRINT_ENABLE(pc.printf("Starting calibration\n\r"););
                        CALIBRATION_OFFSET = getAverageSamples(1000,10)-tare;
                        IF_PRINT_ENABLE(pc.printf("Calibration=  %f\n\r",  calibration*3.3););

                    } else {
                        IF_PRINT_ENABLE(pc.printf("ERROR: TARE FIRST\n\r"););
                    }
                    break;
                
        }
    }
}