#ifndef Verzender_h
#define Verzender_h
#include "mbed.h"
#include <RF24Network.h>
#include <RF24.h>

#define nrf_CE      D4
#define nrf_CSN     D3
#define spi_SCK     A1
#define spi_MOSI    A6
#define spi_MISO    A5

#define INIT            '1'
#define TARE            '2'
#define TARE_FIRST      '3'
#define TARE_COMPLETE   '4'
#define TARE_ERROR      '5'
#define POSITION        '6'
#define POSITION_WAIT   '7'
#define POSITION_ERROR  '8'
#define READ            '9'
#define RECEIVE         'a'
#define STARTUP         'b'
#define STARTUP_SUCCES  'c'
#define BATTERY         'd'


#ifdef PRINT_ENABLE
    #define IF_PRINT_ENABLE(x) ({x;})
    #else
    #define IF_PRINT_ENABLE(x)
    #endif

//Identificatie verzender/ontvanger
const uint16_t this_node = 01;
const uint16_t other_node = 00;

struct payload_t {
    bool reedsensor;
    float gram;
    bool messageAvailable;
    char messageIndex;
};

enum State {State_init,
            State_tare,
            State_position,
            State_read,
            State_receive,
            State_calibrate
           };

struct state_Packet {
    char setstate;
};


class Verzender
{
private:


public:
    Verzender();
    
    /**
    Update to receive a message available for this node
    */
    void update();
    
    
    /**
        Send a message to the receiver
    
        @param message of type payload_t
    */
    bool write(payload_t message);
    
    
    /**
    Test whether there is a message available for this node
    */
    bool available();
    
    
    /**
    Read a message to the receiver

    @return message of type state_packet
    */
    state_Packet read();
    
    
    /*messageIndex:
        0: Nothing wrong
        1: Tare first
        2: Error on Position
        3: Bad Tare value (<2.5V)
*/
    void sendMessage(char index);
    
    void Verzender::printDetails();
};

#endif





