#include "mbed.h"
#include "LCD.h"

void toggle_enable(void) ;
void Ligne1(void), Ligne2(void), Ligne3(void), Ligne4(void) ;

// Le mapping du LCD 4x20 (GDM2004D) sur le MBED
DigitalOut RS(p26);
DigitalOut E(p25);
BusOut Data(p21,p22,p23,p24);      // ordre D4-D5-D6-D7

void LCD_Write(char *pBuf, unsigned char byLigne) {
unsigned char byIndex ;
unsigned char bySize ;

    switch(byLigne) {
    case 1 : Ligne1() ; break ;
    case 2 : Ligne2() ; break ;  
    case 3 : Ligne3() ; break ;
    case 4 : Ligne4() ; break ;
    default : Ligne1() ; break ;
    }
    RS.write(1);
    
    bySize = strlen(pBuf) ;
    if (bySize > 20)      // Afficheur de 20 colonnes maxi
        bySize = 20 ;
   
    for (byIndex=0 ; byIndex <bySize ; byIndex++) {
        Data.write((pBuf[byIndex])>>4);
        toggle_enable();
        Data.write((pBuf[byIndex])&0x0F); 
        toggle_enable();    
    }
}

void Ligne1(void) {
    // Mode commande => RS et E a 0V 
    RS.write(0);
    E.write(0);
    // Set DDRAM address (D7=1)
    // D7 - D6 - D5 - D4 - D3 - D2 - D1 - D0
    // 1    a6   a5   a4   a3   a2   a1   a0
    // Soit 0x80 pour la ligne 1
    Data.write(0x08);    // En mode 4 bits les Poids Forts d'abord
    toggle_enable();
    Data.write(0x00);    // En mode 4 bits les poids faibles ensuite
    toggle_enable();  
}    
void Ligne2(void) {       
    // Mode commande => RS et E a 0V  
    RS.write(0);
    E.write(0);  
    // Set DDRAM address (D7=1)
    // D7 - D6 - D5 - D4 - D3 - D2 - D1 - D0
    // 1    a6   a5   a4   a3   a2   a1   a0
    // Soit 0xC0 pour la ligne 2
    Data.write(0x0C);    // En mode 4 bits les Poids Forts d'abord
    toggle_enable();
    Data.write(0x00);    // En mode 4 bits les poids faibles ensuite
    toggle_enable();
}
void Ligne3(void) {
    // Mode commande => RS et E a 0V 
    RS.write(0);
    E.write(0);
    // Set DDRAM address (D7=1)
    // D7 - D6 - D5 - D4 - D3 - D2 - D1 - D0
    // 1    a6   a5   a4   a3   a2   a1   a0
    // Soit 0x94 pour la ligne 3
    Data.write(0x09);    // En mode 4 bits les Poids Forts d'abord
    toggle_enable();
    Data.write(0x04);    // En mode 4 bits les poids faibles ensuite
    toggle_enable();
}
void Ligne4(void) {
    // Mode commande => RS et E a 0V 
    RS.write(0);
    E.write(0);   
    // Set DDRAM address (D7=1)
    // D7 - D6 - D5 - D4 - D3 - D2 - D1 - D0
    // 1    a6   a5   a4   a3   a2   a1   a0
    // Soit 0xD4 pour la ligne 4
    Data.write(0x0D);    // En mode 4 bits les Poids Forts d'abord
    toggle_enable();
    Data.write(0x04);    // En mode 4 bits les poids faibles ensuite
    toggle_enable();
}

void LCD_Init(void) {

    // Init du LCD --> mode commande => RS et E a 0V
    wait(0.02);
    RS.write(0);
    E.write(0);

    // Function Set (D5=1)
    // D7 - D6 - D5 - D4 - D3 - D2 - D1 - D0
    // 0    0    1    DL   N    F    -    -
    // DL: Interface data length control bit
    // DL = 1 ... 8-bit mode 
    // DL = 0 ... 4-bit mode
    // N: Display line number control bit
    // N = 0 ... 1-line display mode
    // N = 1 ... 2-line display mode
    // F: Display line number control bit
    // F = 0 ... 5x8 dots format 
    // F = 1 ... 5x11 dots format
    // Soit 0x28
    Data.write(0x02);    // En mode 4 bits les Poids Forts d'abord
    toggle_enable();
    Data.write(0x08);    // En mode 4 bits les poids faibles ensuite
    toggle_enable();
    
    // Entry Mode Set (D2=1)
    // D7 - D6 - D5 - D4 - D3 - D2 - D1 - D0
    // 0    0    0    0    0    1    I/D  SH
    // I/D = 0 ... Decrement (cursor shift left)
    // I/D = 1 ... Increment (cursor shift right)
    // Soit 0x06
    Data.write(0x00);    // En mode 4 bits les Poids Forts d'abord
    toggle_enable();
    Data.write(0x06);    // En mode 4 bits les poids faibles ensuite
    toggle_enable();
   
    // Display on/off control (D3=1)
    // D7 - D6 - D5 - D4 - D3 - D2 - D1 - D0
    // 0    0    0    0    1    D    C    B
    // D: Display ON/OFF control bit
    // C: cursor ON/OFF control bit
    // B: Cursor blink ON/OFF control bit
    // D/C/B = 0 ... OFF
    // D/C/B = 1 ... ON
    // Soit 0x0F
    Data.write(0x00);    // En mode 4 bits les Poids Forts d'abord
    toggle_enable();
    Data.write(0x0F);    // En mode 4 bits les poids faibles ensuite
    toggle_enable();
    
    // Clear Display (D0=1)
    // D7 - D6 - D5 - D4 - D3 - D2 - D1 - D0
    // 0    0    0    0    0    0    0    1
    // Soit 0x01
    Data.write(0x00);    // En mode 4 bits les Poids Forts d'abord
    toggle_enable();
    Data.write(0x01);    // En mode 4 bits les poids faibles ensuite
    toggle_enable();
    
    // Set DDRAM address (D7=1)
    // D7 - D6 - D5 - D4 - D3 - D2 - D1 - D0
    // 1    a6   a5   a4   a3   a2   a1   a0
    // Soit 0x80 pour la ligne 1
    Data.write(0x08);    // En mode 4 bits les Poids Forts d'abord
    toggle_enable();
    Data.write(0x00);    // En mode 4 bits les poids faibles ensuite
    toggle_enable();
    
    
    // Return home (D1=1)
    // D7 - D6 - D5 - D4 - D3 - D2 - D1 - D0
    // 0    0    0    0    0    0    1    -
    // Soit 0x02
    Data.write(0x00);    // En mode 4 bits les Poids Forts d'abord
    toggle_enable();
    Data.write(0x02);    // En mode 4 bits les poids faibles ensuite
    toggle_enable();
}
void LCD_Cls(void) {
    // Effacement du LCD --> mode commande => RS et E a 0V
    RS.write(0);
    E.write(0);
    // Clear Display (D0=1)
    // D7 - D6 - D5 - D4 - D3 - D2 - D1 - D0
    // 0    0    0    0    0    0    0    1
    // Soit 0x01
    Data.write(0x00);    // En mode 4 bits les Poids Forts d'abord
    toggle_enable();
    Data.write(0x01);    // En mode 4 bits les poids faibles ensuite
    toggle_enable();
}   
    
void toggle_enable(void){
  E.write(1);
  wait(0.001);
  E.write(0);
  wait(0.001);
}
