///////////////////////////////////////////////////////////////////////////
//
// AUTO2 - Machine a etats - Chronometre
// Cible : MBED LPC1768
// Langage C
//
//
// PhC : OK le 07/04/2015
///////////////////////////////////////////////////////////////////////////
// INCLUDES
#include "mbed.h"
#include "LCD.h"

// CONSTANTES
#define SMAX 20

// Definition des constantes evenement
#define RIEN    0
#define MS      1    
#define LR      2
#define TIME    3

// Definition des constantes etats
#define STOP 0      //déclaration de l'état 0 STOP
#define RUN  1      //déclaration de l'état 1 RUN
#define LAP  2      //déclaration de l'état 2 LAP


// PROTOTYPES
int  EventHandler(void) ;
void Init(void) ;
void Algo1(void) ;
void Algo2(void) ;
int a00(void);
int a01(void);
int a02(void);
int a03(void);
int a04(void);
int a05(void);
int a06(void);
int a07(void);
int a08(void);
void Affiche(void);
void Compte();
void Affiche2();

// OBJETS 

DigitalIn bBPMS (p12);       //déclaration du bouton poussoir MS à la broche p12
DigitalIn bBPLR (p11);       //déclaration du bouton poussoir LR à la broche p11
Timer timer1;
int giMS_memo = 0;
int giLR_memo = 0;

// GLOBALS

// Variables globales evenements
int giEvent ;

// Variable d'etat du systeme
int giEtat = STOP ;

// Le coeur de la FSM  : un tableau de pointeurs sur fonctions de type
// int fct (void) ; 4 lignes (evenements) - 3 colonnes (etats)

int(*automate [4][3]) (void) = {
    //  STOP   RUN   LAP 
        {a00 , a00 , a00},
        {a01 , a02 , a07},
        {a08 , a04 , a05},
        {a00 , a03 , a06}
    };


// Variables de memorisation pour le gestionnaire d'evenements

// Variables de gestion Heure, Minute, Seconde, Dixieme

unsigned char gbyD,gbyS,gbyM,gbyH;;   //déclaration variable de temps(dizième,seconde,minute,heure)


/////////////////////////////////////////////////////////////////////////
// Programme principal 
/////////////////////////////////////////////////////////////////////////
void Init(void) {
    
    LCD_Init();
    LCD_Cls();
    LCD_Write("TIME=00;00;00;00",1);
    //bBPMS.mode(PullDown);
    gbyD=0;
    gbyS=0;
    gbyM=0;
    gbyH=0;
}

int main()
{
    printf("\n\rDemarrage du programme\n\r") ;
    Init() ;
    while(true) {

        // Appel au gestionnaire d'evenements
        giEvent = EventHandler() ;
        // Appel a la machine a etats
        //Algo1() ;
        Algo2() ;
    }
}

/////////////////////////////////////////////////////////////////////////
// Gestionnaire d'evenements
/////////////////////////////////////////////////////////////////////////
int EventHandler(void) {

int iMS,iLR;
    iMS = bBPMS.read();     //lecture du bouton poussoir MS
    iLR = bBPLR.read();     //lecture du bouton poussoir LR
    if(giMS_memo < iMS )        //front montant de MS
    {
        //printf(" Evenement = MS \n\r ");
        giMS_memo = iMS;        //memo
        return MS;
    }
    giMS_memo = iMS;        //memo
    
    if(giLR_memo < iLR )        //front montant de LR
    {
        //printf(" Evenement = LR \n\r ");
        giLR_memo = iLR;
        return LR;
    }
    giLR_memo = iLR;        //memo
    
    if(timer1.read_ms() >= 100)
    {
 
        //printf(" Evenement = TIME \n\r ");
        timer1.reset();
        return TIME;
    }
return RIEN;
}


/////////////////////////////////////////////////////////////////////////
// Les moteurs d'automate
/////////////////////////////////////////////////////////////////////////
void Algo2(void) {

int (*FctPtr)(void);
int iEtatFutur;
FctPtr = automate[giEvent][giEtat];
iEtatFutur=(*FctPtr)();
giEtat = iEtatFutur;

}
/////////////////////////////////////////////////////////////////////////
// Les actions élémentaires
/////////////////////////////////////////////////////////////////////////
int a00(void)
{
    //printf("a00\n\r");
    return giEtat;
}

int a01(void)
{
    //printf("a01\n\r");
    //printf("RUN\n\r");
    timer1.reset();
    timer1.start();
    Affiche();
    return RUN;
}

int a02(void)
{
    //printf("a02\n\r");
    //printf("STOP\n\r");
    timer1.stop();
    Affiche();
    return STOP;
}

int a03(void)
{
    //printf("a03\n\r");
    //printf("RUN\n\r");
    Compte();
    Affiche();
    return RUN;
}

int a04(void)
{
    //printf("a04\n\r");
    //printf("LAP\n\r");
    Affiche2();
    return LAP;
}

int a05(void)
{
    //printf("a05\n\r");
    //printf("RUN\n\r");
    Affiche();
    return RUN;
}

int a06(void)
{
    //printf("a06\n\r");
    //printf("LAP\n\r");
    Compte();
    Affiche();
    return LAP;
}

int a07(void)
{
    //printf("a07\n\r");
    //printf("STOP\n\r");
    timer1.stop();
    Affiche();
    return STOP;
}

int a08(void)
{
    //printf("a08\n\r");
    //printf("STOP\n\r");
    gbyH=gbyM=gbyS=gbyD=0;
    Affiche();
    return STOP;
}
  
///////////////AUTRE FONCTIONS////////////////////

void Affiche(void)
{
    char Smessage [SMAX + 1];
    sprintf ( Smessage, " TIME = %02d:%02d:%02d:%02d ",gbyH,gbyM,gbyS,gbyD);
    LCD_Write ( Smessage,1);
}

void Affiche2(void)
{
    char Smessage [SMAX + 1];
    sprintf ( Smessage, " TIME = %02d:%02d:%02d:%02d ",gbyH,gbyM,gbyS,gbyD);
    LCD_Write ( Smessage,2);
}

void Compte()
{
    gbyD++;
    if (gbyD > 9)
    {
        gbyD = 0;
        gbyS++;
        if (gbyS > 59)
        {
            gbyS=0;
            gbyM++;
            if (gbyM > 59)
            {
                gbyM=0;
                gbyH++;
                if (gbyH > 23)
                {
                    gbyH = 0;
                }
            }
        }
    }
}

