/**
 * Copyright (c) 2015 Digi International Inc.,
 * All rights not expressly granted are reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Digi International Inc. 11001 Bren Road East, Minnetonka, MN 55343
 * =======================================================================
 */

#include "mbed.h"
#include "XBeeLib.h"
#if defined(ENABLE_LOGGING)
#include "DigiLoggerMbedSerial.h"
using namespace DigiLog;
#endif


#define REMOTE_NODE_ADDR64_MSB  ((uint32_t)0x0013A200)

//#error "Replace next define with the LSB of the remote module's 64-bit address (SL parameter)"
#define REMOTE_NODE_ADDR64_LSB  ((uint32_t)0x40E779AF)

#define REMOTE_NODE_ADDR64      UINT64(REMOTE_NODE_ADDR64_MSB, REMOTE_NODE_ADDR64_LSB)

using namespace XBeeLib;

//feux gauche
    //rouge
DigitalOut feux_gauche_rouge(p30);
    //orange
DigitalOut feux_gauche_orange(p28);
    //vert
DigitalOut feux_gauche_vert(p26);

    //liste des message a envoyer rouge et vert seulement pour le coordinateur
    ////////////////////////// 
    /////
    char rouge[] = "r";
    char vert[] = "v";
    /////
    uint8_t ok = 0x02;
    //////////////////////////


Serial *log_serial;

/** Callback function, invoked at packet reception */
static void receive_cb(const RemoteXBeeZB& remote, bool broadcast, const uint8_t *const data, uint16_t len)
{
    const uint64_t remote_addr64 = remote.get_addr64();

    log_serial->printf("\r\nGot a %s RX packet [%08x:%08x|%04x], len %d\r\nData: ", broadcast ? "BROADCAST" : "UNICAST", UINT64_HI32(remote_addr64), UINT64_LO32(remote_addr64), remote.get_addr16(), len);

    for (int i = 0; i < len; i++)
        log_serial->printf("%02x ", data[i]);
        
    log_serial->printf("\r\n");
}


static void send_explicit_data_to_remote_node(XBeeZB& xbee, const RemoteXBeeZB& RemoteDevice,int message){
    
    //const uint8_t data_len = strlen(data);
    const uint8_t dstEP = 0xE8;
    const uint8_t srcEP = 0xE8;
    const uint16_t clusterID = 0x0011;
    const uint16_t profileID = 0xC105;

    char data1[]="r";
    char data2[]="v";
    char data3[]="e";
    if (message ==0){
        const TxStatus txStatus = xbee.send_data(RemoteDevice, dstEP, srcEP, clusterID, profileID, (const uint8_t *)data1, strlen(data1)); 
        if (txStatus == TxStatusSuccess)
            log_serial->printf("send_explicit_data_to_remote_node OK\r\n");
        else
            log_serial->printf("send_explicit_data_to_remote_node failed with %d\r\n", (int) txStatus);
    }
    else if (message ==1){
        const TxStatus txStatus = xbee.send_data(RemoteDevice, dstEP, srcEP, clusterID, profileID, (const uint8_t *)data2, strlen(data2)); 
        if (txStatus == TxStatusSuccess)
            log_serial->printf("send_explicit_data_to_remote_node OK\r\n");
        else
            log_serial->printf("send_explicit_data_to_remote_node failed with %d\r\n", (int) txStatus);
    }
    else {
        const TxStatus txStatus = xbee.send_data(RemoteDevice, dstEP, srcEP, clusterID, profileID, (const uint8_t *)data3, strlen(data3));
        if (txStatus == TxStatusSuccess)
            log_serial->printf("send_explicit_data_to_remote_node OK\r\n");
        else
            log_serial->printf("send_explicit_data_to_remote_node failed with %d\r\n", (int) txStatus);
    }
   
    
}


int main()
{
    log_serial = new Serial(DEBUG_TX, DEBUG_RX);
    log_serial->baud(9600);
    log_serial->printf("Sample application to demo how to receive unicast and broadcast data with the XBeeZB\r\n\r\n");
    log_serial->printf(XB_LIB_BANNER);
    


#if defined(ENABLE_LOGGING)
    new DigiLoggerMbedSerial(log_serial, LogLevelInfo);
#endif

    XBeeZB xbee = XBeeZB(RADIO_TX, RADIO_RX, RADIO_RESET, NC, NC, 9600);

    /* Register callbacks */
    xbee.register_receive_cb(&receive_cb);

    RadioStatus const radioStatus = xbee.init();
    MBED_ASSERT(radioStatus == Success);

    /* Wait until the device has joined the network */
    log_serial->printf("Waiting for device to join the network: ");
    while (!xbee.is_joined()) {
        wait_ms(1000);
        log_serial->printf(".");
    }
    log_serial->printf("OK\r\n");

    int i =0;
    const RemoteXBeeZB remoteDevice = RemoteXBeeZB(REMOTE_NODE_ADDR64);
    while (true) {
        i++;
        uint32_t receive_value = xbee.process_rx_frames();
        log_serial->printf("%d");
        wait_ms(100);
        log_serial->printf(".");
        
        
        //partie gestion des feux a mettre sur le coordinateur 
        /////////////////////////////////////////////
        if(i==10){
            send_explicit_data_to_remote_node(xbee, remoteDevice,1);
            feux_gauche_rouge = 0;
            feux_gauche_vert = 1;
            }
        if(i==20){
            send_explicit_data_to_remote_node(xbee, remoteDevice,0);
            feux_gauche_rouge = 1;
            feux_gauche_vert = 0;
            i=0;
            }
        ////////////////////////////////////////////
    }

   // delete(log_serial);
}
