#ifndef MAGNE_WAVE_H
#define MAGNE_WAVE_H

#include "mbed.h"
#include "SoftMCP4922.h"

class MagneWave
{
public:
    /*
     * MagneWave - Magnetone wave player
     * param
     * [in] dac: dac address
     */
    MagneWave( SoftMCP4922 *dac );
    
    /*
     * play - player function
     * param
     * [in] wavefile: file pointer
     */
    void play( FILE *wavefile );

private:
    void dacOut();

    SoftMCP4922 *m_wave_DAC;
    //FILE *m_wavefile;
    Ticker tick;
    unsigned short m_fifo[128];
    volatile short m_wptr;
    volatile short m_rptr;
    bool m_dacOn;
    bool m_fileEnd;
};



#endif  // MAGNE_WAVE_H