#include "MagneWave.h"

#define DATA_OFFSET 44
#define DAC16_CENTER  32768

MagneWave::MagneWave( SoftMCP4922 *dac )
{
    m_wave_DAC = dac;
    m_wave_DAC->write_u16( DAC16_CENTER );
    
    m_wptr = 0;
    m_rptr = 0;
    m_dacOn = false;
    m_fileEnd = false;
    
    NVIC_SetPriority(SysTick_IRQn, 1);
    tick.attach_us( this, &MagneWave::dacOut, 125 ); 
}

void MagneWave::play( FILE *wavefile )
{
    // jump to wave data
    fseek( wavefile, DATA_OFFSET, SEEK_SET );
    
    m_dacOn = true;
    m_fileEnd = false;
    
    while( m_dacOn ){
        if( m_rptr != ( ( m_wptr + 1 ) & 0x7f ) ){

            short dacVal16 = 0;
            unsigned char tmp[2];

            int ret = fread( tmp, 1, 2, wavefile);
            if( ret < 2 ){
                printf("eof\n\r");
                m_fileEnd = true;
                break;
            }
            dacVal16 = tmp[0];
            dacVal16 |= ( tmp[1] << 8 );
            dacVal16 += DAC16_CENTER;
            
            m_fifo[m_wptr]= ( unsigned short )dacVal16;
            m_wptr = ( m_wptr + 1 ) & 0x7f;
        }
    }
    printf("off\n\r");
}

void MagneWave::dacOut()
{
    if ( m_dacOn ) {
        if( m_rptr != m_wptr ){
            m_wave_DAC->write_u16( m_fifo[ m_rptr ] );
            m_rptr = ( m_rptr + 1 ) & 0x7f;
        }else{
            //printf("nohit r=%d,w=%d\n", m_rptr, m_wptr);
            //printf("nh\n");
            if( m_fileEnd ){
                printf("eof\n\r");
                m_wptr = 0;
                m_rptr = 0;
                m_dacOn = false;
                m_fileEnd = false;
                m_wave_DAC->write_u16( DAC16_CENTER );
            }
        }
    }
}


