#include "mbed.h"

// Simple Spi Slave
// Simple SPI Slave receives bytes on the SPI and will echo back the byte received on the next request.

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
SPISlave spi(p11, p12, p13, p14); // mosi, miso, sclk, ssel

int main() {
    int v = 0xff;
    long c = 0;
    int ch;
    int echoMode = 1;
    
    pc.printf("Simple SPI Slave Test\r\n");
    pc.printf("Uses MBED's SPISlave library (1 byte in - 1 byte out)\r\n");
    pc.printf("\r\n R : to add an extra reply() call\r\n" );
    pc.printf(" I : Make a read() call\r\n" );
    pc.printf(" S : Read receive status\r\n" );
    pc.printf(" N : No reply()\r\n" );
    spi.format(8,3);

    spi.reply( v );

    while(1) {
        if( spi.receive() ) {
            // Data available - our trigger to do something
            v = spi.read();   // Read byte from master
            if ( echoMode ) {
                // and send last data back
                spi.reply( v );
            }
            pc.printf( "%ld In %02x\r\n", c++, v );
        }

        if ( pc.readable() ) {
            ch = pc.getc();
            switch ( ch ) {
                case 'R':
                case 'r':
                    spi.reply( 'B' );
                    pc.printf( "Bogus Replay added\r\n" );
                    break;
                case 'I':
                case 'i':
                    v = spi.read();
                    pc.printf( "Extra read = %02x\r\n", v );
                    break;
                case 'S':
                case 's':
                    v = spi.receive();
                    pc.printf( "Status = %02x\r\n", v );
                    break;
                case 'N':
                case 'n':
                    echoMode = !echoMode;
                    pc.printf( "Echo mode = %d\r\n", (echoMode & 1) );
                    break;
            }
        }
    }
}
