#include "mbed.h"

// Simple SPI Master
// Simply sends incrementing bytes and receives the echo from the previous one

SPI spi(p5, p6, p7); // mosi, miso, sclk
DigitalOut cs(p8);

Serial pc(USBTX, USBRX); // tx, rx

#define SINGLE 0
#define CONTINUOUS 1

    long c = 0;
    unsigned char r = 0;
    unsigned char v = 0;
    int ch;

void sendbyte() {
    // Select the device by seting chip select low
    cs = 0;
    v = c & 0xff;
    r = spi.write( v );
    // Deselect the device
    cs = 1;

    pc.printf("%ld v=%02x\r\n", c, v);
    if (( c>0 ) && ( r!=(unsigned char)(v-1)) ) {
        pc.printf( "   Echo error %02x!=%02x\r\n", v-1, r );
        pc.printf("Press any key to continue\r\n");
        ch = pc.getc();
    }
    c++;
}

int main() {
    int  mode = 0;
    
    pc.printf("Simple SPI Master Test\r\n");
    pc.printf("Uses MBED's SPI library (1 byte in - 1 byte out)\r\n");
    pc.printf("\r\n C : Toggle continuous mode\r\n" );
    pc.printf(" T : Make a single transmission\r\n" );
    
    // Setup the spi
    // second edge capture, with a 1MHz clock rate
    spi.format(8,3);
    spi.frequency(100000);

    while (1) {
        if ( mode ) {
            wait_ms( 1 );
            sendbyte();
        }
        if ( pc.readable() ) {
            ch = pc.getc();
            switch ( ch ) {
                case 'C':
                case 'c':
                    mode = ! mode;
                    break;
                case 'T':
                case 't':
                    sendbyte();
                    break;
            }
        }        
    }
}