#include "mbed.h"
#include "WiflyInterface.h"
#include "LM75B.h"
#include "MMA7660.h"
#include "C12832.h"
#include "MSCFileSystem.h"
#include "NTPClient.h"


/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p30 is for the reset pin
*     - p29 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p9, p10, p30, p29, "mbed", "password", WPA);
NTPClient ntp; // Don't move this line
MSCFileSystem fs("fs");
C12832 lcd(p5, p7, p6, p8, p11);
DigitalIn my_abort(p14);

// accelerometer
MMA7660 MMA(p28, p27);

// temperature sensor
LM75B tmp(p28,p27);

float x,y,z;
int temp;
char filename[50];

int main()
{
    time_t ctTime;

    // Display welcoming message
    lcd.cls();
    lcd.printf("mbed g monitor\n");

    // Connect to local wifi network
    wifly.init(); //Use DHCP
    while (!wifly.connect());
    lcd.printf("IP Address is %s\n", wifly.getIPAddress());

    // Get current time (UTC) through internet
    lcd.printf("Trying to update time...\n");
    if (ntp.setTime("0.pool.ntp.org") == 0) {
        ctTime = time(NULL);
        set_time(ctTime);
        
        // Display current time (UTC) on the LCD
        lcd.cls();
        lcd.printf("Time (UTC): \n%s\n", ctime(&ctTime));
    } else {
        // Problem setting the current time
        // FIXME allow user to set time and date manually
        lcd.printf("NTP Error, press reset to retry\n");
        while(1);
    }

    wait(3);
    lcd.cls(); // Clear the LCD screen

    // Check for the accelerometer's presence
    if (MMA.testConnection()) {
        for (int j = 0; j < 36; j++) {
            sprintf(filename,"/fs/gmon%d.csv",j);
            lcd.printf("Opening file #%d\n",j);
            
            FILE *fp = fopen(filename,"w");
            // Check if file was properly opened
            if (fp != NULL) {
                printf("Create filehandle for %s\r\n",filename);
                printf("Writing to file\r\n");
        
                // Take 100000 samples per file
                for (int i = 0; i < 100000; i++) {
                    // Read the accelerometer
                    x = MMA.x();
                    y = MMA.y();
                    z = MMA.z();
                    
                    // Read the temperature
                    temp = (int)tmp.read();
                    
                    // Get current time
                    ctTime = time(NULL);
                    
                    // Write the data to file
                    fprintf(fp,"%0.5f, %0.5f, %0.5f, %d, %s",x,y,z,temp, ctime(&ctTime));
                    
                    // If something goes wrong/was not right press on the joystick button
                    if (my_abort){
                        // Close the currently opened file to prevent corrupt data
                        fclose(fp);
                        lcd.cls();
                        lcd.printf("Aborting, USB Flash can be removed\n");
                        
                        // infinite loop
                        while(1);
                    }
                    
                    // take one sample every 30 seconds                        
                    wait(30);
                }
                fclose(fp);
                printf("Close the handle\n");
            } else {
                printf("Can't open %s\r\n",filename);
            }
        }
    }
    lcd.cls(); // Clear the LCD screen
    lcd.printf("End of data acquisition\n");
}
