#include "mbed.h"
#include "motor_api.h"

#define init_v 10  // period in 1.35 ~170ms
 BX_motor::BX_motor(char type){
   //need N level????
  engine_enable = new DigitalOut(PTE21);  
  
   *engine_enable=1;
    
    Type=type;
    switch (type){
     
        case 'A':
          forward_A = new PwmOut(PTC3);
          backward_A = new   PwmOut(PTC4);
         
         forward_A->period_ms(init_v);
         backward_A->period_ms(init_v);
         *forward_A=0.5f;
         *backward_A=0.5f;
        
        break;
        
        
       case 'B':     
         
         forward_B = new PwmOut(PTE29);
         backward_B = new PwmOut(PTE23);
         forward_B->period_ms(init_v);
         backward_B->period_ms(init_v);
         *forward_B=0.5f;
         *backward_B=0.5f;
       break;
     
     
     
  }
     
    }


// level: -1.0 ~1.0
void BX_motor::rotate(float level){
       
       Level=level;
    
       if(level >0){
         
         switch(Type){
         
         case 'A':
              *forward_A=level;
              *backward_A=0;
         break;
         case 'B':
              *forward_B=level;
              *backward_B=0;
         break;  
         }
           
       }else if(level <0){
           
            level=-1.0*level;
           
         switch(Type){
         
         case 'A':
             *forward_A=0;
              *backward_A=level;
         break;
         case 'B':
            *forward_B=0;
              *backward_B=level;
         break;  
         }
           
      }
       else{
         switch(Type){
         
            case 'A':
              *forward_A=1.0f;
              *backward_A=1.0f;
                
            break;
            case 'B':
               *forward_B=1.0f;
              *backward_B=1.0f;
            break;  
         }
           
           
           }
       
       
    
    
    
    
    
    
    
}



