#include "mbed.h"

#define PI 3.1415926f
DigitalOut d_out(D2);

DigitalOut led_r(LED_RED);
DigitalOut led_g(LED_GREEN);
Serial pc(USBTX, USBRX);

Ticker tick_DAC;
Ticker tick_test;
AnalogOut DAC(PTE30);
const long num_samp_per_sec = 15000;
const int freq_DAC[4] = {1,10,100,1000};
long count_DAC;
int sel_freq_DAC;
bool on_DAC;

AnalogIn in_0(A0);
AnalogIn in_1(A1);
bool flag_for_d;

void sine_gen() {
    float tem = on_DAC? 0.5*sin(2*PI*freq_DAC[sel_freq_DAC]*count_DAC/num_samp_per_sec) + 0.5 : 0.0;
    //float temf = 0.1;
    //float tem = 0.5*sin(2*PI*temf*count_DAC/num_samp_per_sec) + 0.5;
    //if (count_DAC % 10 == 0) pc.printf("write%f\n",tem);
    DAC.write(tem);
    count_DAC += 1;
    if (count_DAC == num_samp_per_sec - 1) count_DAC = 0;
    //if (count_DAC == 10*num_samp_per_sec - 1) count_DAC = 0;
}

void init() {
    d_out = false;
    flag_for_d = false;
    
    count_DAC = 0;
    sel_freq_DAC = 0;
    on_DAC = true;
}

void print_in() {
    pc.printf("read %f\n",in_0.read());
}

int main() {
    init();
    pc.printf("Welcome\na:on/off (default: on) s:1Hz d:10Hz f:100Hz g:1kHz\nq:digital on w:digital off\np:print values\n");
    tick_DAC.attach_us(&sine_gen, (double)1000000/num_samp_per_sec);
    //tick_test.attach(&print_in, 0.7f);
    
    //AnalogIn in(A0);
    while (true) {
        if (pc.readable()) {
            char c = pc.getc();
            switch(c) {
                case 'a': on_DAC = !on_DAC; break;
                case 's': sel_freq_DAC = 0; break;
                case 'd': sel_freq_DAC = 1; break;
                case 'f': sel_freq_DAC = 2; break;
                case 'g': sel_freq_DAC = 3; break;
                case 'q': d_out = true; break;
                case 'w': d_out = false; break;
                case 'p': {
                    pc.printf("sine value:%f, digital value:%f\n", in_0.read(), in_1.read()); break;
                }
                default: break;
            }
        }
        
        float value_0 = in_0.read();
        if (value_0 > 0.75f) {
            led_r = false;
            led_g = false;
            //pc.printf("read 11 %f\n",value_0);
        } else if (value_0 > 0.5f) {
            led_r = false;
            led_g = true;
            //pc.printf("read 10 %f\n",value_0);
        } else if (value_0 > 0.25f) {
            led_r = true;
            led_g = false;
            //pc.printf("read 01 %f\n",value_0);
        } else {
            led_r = true;
            led_g = true; 
            //pc.printf("read 00 %f\n",value_0);
        }
        /*
        float value_1 = in_1.read();
        if (!flag_for_d&&value_1 > 0.5) {
            pc.printf("Digital output high\n");
            flag_for_d = !flag_for_d;
        }
        else if (flag_for_d&&value_1 < 0.5) {
            pc.printf("Digital output low\n");
            flag_for_d = !flag_for_d;
        }
        */
        //if (in > 0.5f) led_r = 0;
        //else led_r = 1;
        //wait (0.5f);
    }
}