#include "mbed.h"

char* readstring(char* add);
int touchSense( );
char readkey( );

Serial pc(USBTX, USBRX);
AnalogIn input0(p20);
AnalogIn input1(p17);
DigitalIn charger0(p19);
DigitalIn charger1(p16);
DigitalOut ground0(p18);
DigitalOut ground1(p15);

int main() {
    char hstr[100];
    char ustr[100];
    char* sadd = &hstr[0];
    char* eadd;
    char key;
    int len, i, j;
    eadd = readstring(sadd);
    len = eadd - sadd;
    for (i = 0; i <= len; i++)
        pc.printf("%c", hstr[i]);
    pc.printf("\n");
    for (i = 0; i <= len; i++){
        while (1){
            key = readkey( );
            if (key == 'e')
                pc.printf("TOUCH ERROR!");
            else if ( key == '0' || key == '1')
                break;
            wait(0.005);
        }
        pc.printf("%c\n", key);
        ustr[i] = key;
    }
    i = len;    
    while (1){
         for (j = 0; j<= len; j++){
            if (hstr[j] != ustr[(i+j+1) % (len+1)])
                break;
        }
        if (j == len+1)
            pc.printf("MATCH!");
        if ( i == len )
            i = 0;
        else  
            i++;    
        while (1){
            key = readkey( );
            if (key == 'e')
                pc.printf("TOUCH ERROR!");
            else if ( key == '0' || key == '1')
                break;
            wait(0.005);
        }
        pc.printf("%c\n", key);
        ustr[i] = key;
    }             
}

char* readstring(char* add)
{
    char x;
    int flag = 0;
    while(1){
        if (pc.readable()){
            x = pc.getc();
            if (x=='S' && flag == 0)
                flag = 1;
            else if (x=='E' && flag==1){
                flag = 0;
                break;
            }
            else if (flag==1){
                if (x=='1' || x=='0'){
                    *add = x;
                    add++;
                }
                else
                    pc.printf("HOST ERROR!\n"); 
            }       
        }
    }
    return add-1;
}

int touchSense( )
{
    float sample0, sample1;
    ground0=0;
    ground1=0;
    charger0.mode(PullUp);
    charger1.mode(PullUp);
    charger0.mode(PullNone);
    charger1.mode(PullNone);
    sample0 = input0.read();
    sample1 = input1.read();
    if (sample0 < 0.3 && sample1 < 0.3)
        return 2;
    else if (sample0 < 0.3)
        return 0;
    else if (sample1 < 0.3)
        return 1;
    else
        return -1;
}

char readkey( )
{
    int T = -1;
    char key = 'n';
    
    T = touchSense();
    if (T==0) {
        wait(0.005);
        T = touchSense();
        if (T==0){
            while (1){
                wait(0.005);
                T = touchSense();
                if (T==-1){
                    wait(0.005);
                    T = touchSense();
                    if (T==-1){
                        key = '0';
                        break;
                    }
                }
                else if (T==2)
                    break; 
            }        
        }
    }
    else if (T==1){
        wait(0.005);
        T = touchSense();
        if (T==1){
            while (1){
                wait(0.005);
                T = touchSense();
                if (T==-1){
                    wait(0.005);
                    T = touchSense();
                    if (T==-1){
                        key = '1';
                        break;
                    }
                }
                else if (T==2)
                    break;  
            }
        }
    }
    else if (T==-1)
        key = 'n';
    if (T==2){
        wait(0.005);
        T = touchSense();
        if (T==2){
            while (1){
                wait(0.005);
                T = touchSense();
                if (T==-1){
                    wait(0.005);
                    T = touchSense();
                    if (T==-1){
                        key = 'e';
                        break;
                    }
                }
            }
        }
    }
    return key;         
}