#include "pt.h"
#include "mbed.h"

static int protothread1(struct pt *pt);
static int protothread2(struct pt *pt);
int readstring(char c);
int touchSense( );
char readkey( );

AnalogIn input0(p20);
AnalogIn input1(p17);
DigitalIn charger0(p19);
DigitalIn charger1(p16);
DigitalOut ground0(p18);
DigitalOut ground1(p15);
Serial pc(USBTX, USBRX); // tx, rx

DigitalOut myled(LED1);

static struct pt pt1, pt2;
static int protothread1_flag;
char x, k;
char hstr[100], ustr[100];
int hindex = 0, uindex = 0, len = 0;
int str_flag = 0, cmp_flag = 0;

int main(void)
{
  PT_INIT(&pt1);
  PT_INIT(&pt2);

  while(1) {
    protothread1(&pt1);
    protothread2(&pt2);
  }
}


static int protothread1(struct pt *pt)
{
  PT_BEGIN(pt);
  while(1) {
    PT_WAIT_UNTIL(pt, pc.readable( )==1);
    x = pc.getc( );
    protothread1_flag = readstring(x);
  }
  PT_END(pt);
}

static int protothread2(struct pt *pt)
{
  int j;
  PT_BEGIN(pt);
  while(1) {
    PT_WAIT_UNTIL(pt, protothread1_flag != 0);
    k = readkey( );
    if (k == 'e')
        pc.printf("TOUCH ERROR");
    else if (k == '1' || k == '0'){
        ustr[uindex] = k;
        printf("%c\n", ustr[uindex]);
        if (uindex == len){
            uindex = 0;
            cmp_flag = 1;
        }
        else 
            uindex++;
        if ( cmp_flag == 1 ){
            for (j = 0; j <= len; j++){
//                pc.printf("%c", ustr[j]);      
                if (hstr[j] != ustr[(uindex+j) % (len+1)])
                    break; 
                }
            if (j == len+1)
                pc.printf("MATCH!");                    
        }
    }
    if (pc.readable( )){
        x = pc.getc( );
        protothread1_flag = readstring(x);
    }
    wait (0.005);
  }
  PT_END(pt);
}

int readstring(char c)
{
    int i;
    int host_flag = 0;
    if (x=='S'){
        str_flag = 1;
        hindex = 0;
    }
    else if (x=='E' && str_flag==1){
        str_flag = 0;
        host_flag = 1;
        cmp_flag = 0;
        len = hindex - 1;
        for (i = 0; i <= len; i++)
            pc.printf("%c", hstr[i]);
    }
    else if (str_flag==1){
        if (x=='1' || x=='0'){
            hstr[hindex] = x;
            hindex++;
        }
        else
            pc.printf("HOST ERROR!\n"); 
    }
    return host_flag;       
}

int touchSense( )
{
    float sample0, sample1;
    ground0=0;
    ground1=0;
    charger0.mode(PullUp);
    charger1.mode(PullUp);
    charger0.mode(PullNone);
    charger1.mode(PullNone);
    sample0 = input0.read();
    sample1 = input1.read();
    if (sample0 < 0.3 && sample1 < 0.3)
        return 2;
    else if (sample0 < 0.3)
        return 0;
    else if (sample1 < 0.3)
        return 1;
    else
        return -1;
}

char readkey( )
{
    int T = -1;
    char key = 'n';
    
    T = touchSense();
    if (T==0) {
        wait(0.005);
        T = touchSense();
        if (T==0){
            while (1){
                wait(0.005);
                T = touchSense();
                if (T==-1){
                    wait(0.005);
                    T = touchSense();
                    if (T==-1){
                        key = '0';
                        break;
                    }
                }
                else if (T==2)
                    break; 
            }        
        }
    }
    else if (T==1){
        wait(0.005);
        T = touchSense();
        if (T==1){
            while (1){
                wait(0.005);
                T = touchSense();
                if (T==-1){
                    wait(0.005);
                    T = touchSense();
                    if (T==-1){
                        key = '1';
                        break;
                    }
                }
                else if (T==2)
                    break;  
            }
        }
    }
    else if (T==-1)
        key = 'n';
    if (T==2){
        wait(0.005);
        T = touchSense();
        if (T==2){
            while (1){
                wait(0.005);
                T = touchSense();
                if (T==-1){
                    wait(0.005);
                    T = touchSense();
                    if (T==-1){
                        key = 'e';
                        break;
                    }
                }
            }
        }
    }
    return key;         
}