#include "mbed.h"

void serial_interrupt( );
void readstring(char c);
int touchSense( );
char readkey( );

Serial pc(USBTX, USBRX); // tx, rx
AnalogIn input0(p20);
AnalogIn input1(p17);
DigitalIn charger0(p19);
DigitalIn charger1(p16);
DigitalOut ground0(p18);
DigitalOut ground1(p15);

char x;
char hstr[100];
int serial_flag = 0;
int str_flag = 0;
int host_flag = 0;
int index = 0;
int len;

int main() 
{
    char key;
    char ustr[100];
    int i, j;
    int cmp_flag = 0;
    pc.attach(&serial_interrupt, Serial::RxIrq);
    while(1){
        if (serial_flag == 1){
            serial_flag = 0;
            readstring(x);
        }
        i = 0;
        cmp_flag = 0;
        while (host_flag == 1){
            key = readkey( );
            if (key == 'e')
                pc.printf("TOUCH ERROR");
            else if (key == '1' || key == '0'){
                ustr[i] = key;
                printf("%c\n", ustr[i]);
                if (i == len){
                    i = 0;
                    cmp_flag = 1;
                }
                else 
                    i++;
                if ( cmp_flag == 1 ){
                    for (j = 0; j <= len; j++){
                        if (hstr[j] != ustr[(i+j) % (len+1)])
                            break; 
                    }
                if (j == len+1)
                    pc.printf("MATCH!");                    
                }
            }
            wait(0.005);
        }        
    }
}

void readstring(char c)
{
    int i;
    if (x=='S'){
        str_flag = 1;
        index = 0;
    }
    else if (x=='E' && str_flag==1){
        str_flag = 0;
        host_flag = 1;
        len = index - 1;
        for (i = 0; i <= len; i++)
            pc.printf("%c", hstr[i]);
    }
    else if (str_flag==1){
        if (x=='1' || x=='0'){
            hstr[index] = x;
            index++;
        }
        else
            pc.printf("HOST ERROR!\n"); 
    }
    return;       
}

int touchSense( )
{
    float sample0, sample1;
    ground0=0;
    ground1=0;
    charger0.mode(PullUp);
    charger1.mode(PullUp);
    charger0.mode(PullNone);
    charger1.mode(PullNone);
    sample0 = input0.read();
    sample1 = input1.read();
    if (sample0 < 0.3 && sample1 < 0.3)
        return 2;
    else if (sample0 < 0.3)
        return 0;
    else if (sample1 < 0.3)
        return 1;
    else
        return -1;
}

char readkey( )
{
    int T = -1;
    char key = 'n';
    
    T = touchSense();
    if (T==0) {
        wait(0.005);
        T = touchSense();
        if (T==0){
            while (1){
                wait(0.005);
                T = touchSense();
                if (T==-1){
                    wait(0.005);
                    T = touchSense();
                    if (T==-1){
                        key = '0';
                        break;
                    }
                }
                else if (T==2)
                    break; 
            }        
        }
    }
    else if (T==1){
        wait(0.005);
        T = touchSense();
        if (T==1){
            while (1){
                wait(0.005);
                T = touchSense();
                if (T==-1){
                    wait(0.005);
                    T = touchSense();
                    if (T==-1){
                        key = '1';
                        break;
                    }
                }
                else if (T==2)
                    break;  
            }
        }
    }
    else if (T==-1)
        key = 'n';
    if (T==2){
        wait(0.005);
        T = touchSense();
        if (T==2){
            while (1){
                wait(0.005);
                T = touchSense();
                if (T==-1){
                    wait(0.005);
                    T = touchSense();
                    if (T==-1){
                        key = 'e';
                        break;
                    }
                }
            }
        }
    }
    return key;         
}

void serial_interrupt( )
{   
    if (pc.readable( )){
        x = pc.getc( );
        serial_flag = 1;
        host_flag = 0;
    }
    return;
}