//-------------------------------------------------
//  音量の調整のためのクラス
//       SD_PlayerSkeleton の派生クラス
//
//  2017/03/22, Copyright (c) 2017 MIKAMI, Naoki
//-------------------------------------------------

#include "VolumeCtrl.hpp"

namespace Mikami
{
    // １ブロック分の信号処理の実行
    void VolumeCtrl::SignalProcessing()
    {
        // １ブロック分のステレオデータを SD から読み込みモノラルにする
        sdReader_.ReadAndToMono(sn_);

        while (!mySai_.IsXferred()) {}  // データの転送が終わるまで待つ
        //--------------------------------------------------------------
        // １ブロック分の処理を行い，その結果を出力する
        // 音響信号の出力：左右チャンネルに同じものを出力
        for (int n=0; n<BUFF_SIZE_; n++)
        {
            int16_t data = volume_*sn_[n];  // 出力の音量を変える
            mySai_.Output(data, data);
        }
        //--------------------------------------------------------------
    }

    // 音量の調整
    void VolumeCtrl::Modefy()
    {
        if (myBar_.Slide())
            volume_ = myBar_.GetValue();
    }

    // 曲の再生時の表示
    void VolumeCtrl::Display()
    {
        Label musicTitle(207, 80, GetFileNameNoExt(), Label::CENTER, Font16);
        ctrl_.Draw();
        myBar_.Redraw();
    }
}
