//-------------------------------------------------
//  音量の調整のためのクラス（ヘッダ）
//       SD_PlayerSkeleton の派生クラス
//
//  2016/11/16, Copyright (c) 2016 MIKAMI, Naoki
//-------------------------------------------------

#ifndef F746_SD_PLAYER_VOLUME_CONTROL_HPP
#define F746_SD_PLAYER_VOLUME_CONTROL_HPP

#include "SD_PlayerSkeleton.hpp"
#include "SeekBar.hpp"

namespace Mikami
{
    class VolumeCtrl : public SD_PlayerSkeleton
    {
    public:
        VolumeCtrl(string str)
            : SD_PlayerSkeleton(str),
              volume_(0.8f),
              ctrl_(207, 140, "Volume", Label::CENTER, Font16),
              myBar_(107, 200, 200, 0, 1, volume_,
                     "MIN", "", "MAX") {}
        virtual ~VolumeCtrl() {}

    private:
        float volume_;
        Label ctrl_;
        SeekBar myBar_;

        // １ブロック分の信号処理の実行
        virtual void SignalProcessing();
        // 音量の調整
        virtual void Modefy();
        // 曲の再生時の表示
        virtual void Display();
    };
}
#endif  // F746_SD_PLAYER_VOLUME_CONTROL_HPP