//--------------------------------------------------------------------
//  SD_PlayerSkeleton クラスの使用例（音量調節付き SD オーディオプレーヤー）
//      SD のファイル: *.wav
//                   PCM，16 ビットステレオ，標本化周波数 44.1 kHz
//                   上記以外の形式は扱わない
//      出力：モノラル（L+R，左右チャンネルに同じものを出力）
//
//  2017/04/09, Copyright (c) 2017 MIKAMI, Naoki
//--------------------------------------------------------------------

#include "VolumeCtrl.hpp"

#include "SAI_InOut.hpp"
#include "LcdPanelFrq.hpp"
#include "GaussRand.hpp"




using namespace Mikami;

int main()
{
    VolumeCtrl myPlayer("SD Player with Volume Control");
    myPlayer.Execute();
    
    
    const int FS = I2S_AUDIOFREQ_48K;       // 標本化周波数：48 kHz
    SaiIO mySai(SaiIO::OUTPUT, 2048, FS);   // オーディオ信号出力用
    LcdPanel myPanel(1.0f/(float)FS);       // LCD パネル表示用
    GaussRand rnd(0.5f, 0);                 // ガウス性ノイズ発生器

    mySai.PlayOut();    // オーディオ信号出力開始

    const float MAX_AMP = 8192.0f;
    while (true)        // 無限ループ
    {
        // 出力バッファへの転送が完了したら以下の処理を行う
        if (mySai.IsXferred())
        {
            for (int n=0; n<mySai.GetLength(); n++)
            {
                // 入力信号の生成
                float phi = myPanel.GetPhi();
                float sn = sinf(phi); // 入力信号となる正弦波を発生
                float noize = myPanel.GetNoiseLevel()*rnd.Next();

                int16_t xn = (int16_t)(MAX_AMP*sn);
                int16_t yn = (int16_t)(MAX_AMP*(sn + noize));
                mySai.Output(xn, yn);       // xn：ノイズなし（左チャンネル）
                                            // yn：ノイズ付加（右チャンネル）
                myPanel.Store(yn, n);       // 表示用として格納
            }

            myPanel.Display();  // 入出力信号の波形表示
        }
        myPanel.Update();   // パネルの状態を読み取り必要なパラメータなどを更新する
    }
}
