
//-------------------------------------------------

#ifndef F746_SD_PLAYER_VOLUME_CONTROL_HPP
#define F746_SD_PLAYER_VOLUME_CONTROL_HPP

#include "SD_PlayerSkeleton.hpp"
#include "SeekBar.hpp"

namespace Mikami
{
    class VolumeCtrl : public SD_PlayerSkeleton
    {
    public:
        VolumeCtrl(string str)
            : SD_PlayerSkeleton(str),
              volume_(0.8f),
              ctrl_(207, 140, "Volume", Label::CENTER, Font16),
              myBar_(107, 200, 200, 0, 1, volume_,
                     "MIN", "", "MAX") {}
        virtual ~VolumeCtrl() {}

    private:
        float volume_;
        Label ctrl_;
        SeekBar myBar_;

      // Thực thi xử lý tín hiệu cho một khối
        virtual void SignalProcessing();
        // Điều chỉnh âm lượng
        virtual void Modefy();
    // Hiển thị khi phát một bài hát
        virtual void Display();
    };
}
#endif  // F746_SD_PLAYER_VOLUME_CONTROL_HPP