//--------------------------------------------------------------
//  フィルタ処理付き SD オーディオプレーヤーで使う大域関数（ヘッダ）
//
//  2016/07/04, Copyright (c) 2016 MIKAMI, Naoki
//--------------------------------------------------------------

#include "MyFunctions.hpp"

// １フレーム分の信号処理 (IIR フィルタ) の実行
void IIR_Filtering(SD_WavReader &sdReader, SaiIO &mySai,
                   float g0, Biquad hn[],
                   int order, bool filterOn)
{
    static int32_t frameSize = mySai.GetLength();
    static Array<int16_t> sn(frameSize);    // フレームバッファ

    // １フレーム分のデータを SD から読み込む
    sdReader.ReadAndToMono(sn);

    while (!mySai.IsXferred()) {}  // データの転送が終わるまで待つ
    //--------------------------------------------------------------
    // １フレーム分の信号処理を行い，その結果を出力する
    for (int n=0; n<frameSize; n++)
    {
        // 縦続形の IIR フィルタ
        float yn = g0*sn[n];
        for (int k=0; k<order/2; k++) yn = hn[k].Execute(yn);

        int16_t value = filterOn ? (int16_t)yn : sn[n];

        // 音響信号の出力，右チャンネルには出力しない
        mySai.Output(value, 0);
    }
    //--------------------------------------------------------------
    mySai.ResetXferred();   // 次のデータ転送に備える
}

// SD カードのファイルのオープン
int32_t SD_Open(SD_WavReader &sdReader,
                string fileName, int32_t frameSize)
{
    sdReader.Open(fileName);
    sdReader.IsWavFile();
    return sdReader.GetSize()/frameSize;
}

// ファイルの選択
//      selectedName:   選択されたファイル名
void SelectFile(ButtonGroup &menu, FileSelector &selector,
                Label &msg, string &selectedName)
{
    selector.DisplayFileList();   
    msg.Draw("Chon File");
    do
    {
        if (selector.Select(selectedName))
            menu.Activate(1);   // PLAY 有効
        wait_ms(200);
    } while (!menu.Touched(1)); // PLAY がタッチされるまで繰り返す
}

// フィルタの変更
void ModifyFilter(DesignerDrawer &drawerObj,
                  ButtonGroup &lpHp, ButtonGroup &onOff,
                  Biquad hn[], Biquad::Coefs ck[],
                  float &g0, bool &filterOn)
{
    // フィルタ処理の有効／無効切り替え
    int sw = 0;
    if (onOff.GetTouchedNumber(sw))
        filterOn = (sw == 0) ? true : false;

    // フィルタの周波数特性の変更
    static int num = 0;
    lpHp.GetTouchedNumber(num);
    BilinearDesign::Type typeLH = (BilinearDesign::Type)num;
    if (drawerObj.ReDesignAndDraw(ck, g0, typeLH))
        for (int k=0; k<drawerObj.GetOrder()/2; k++)
        {
            hn[k].SetCoefficients(ck[k]);
            hn[k].Clear();
        }
}

