/*
  Stewitter.h - Arduino library to Post messages to Twitter with OAuth.
  Copyright (c) arms22 2010 - 2012. All right reserved.
*/
/*
  Twitter.h - Arduino library to Post messages to Twitter.
  Copyright (c) NeoCat 2009. All right reserved.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
*/
/* Modified by 2015 phsfan
 *  for ABIT PHS Shield on mbed
 */

#ifndef Stewitter_H
#define Stewitter_H

#include "mbed.h"
#include "a3gs.h"

class Stewitter_a3gs
{
private:
    A3GS _a3gs;
    char httpBody[a3gsMAX_RESULT_LENGTH + 1];
    const char *token;
    int statusCode;
    uint8_t parseStatus;
    void parse (char *buf);
public:
    Stewitter_a3gs(const char *token, A3GS &a3gs);
    bool post(const char *msg);
    bool lastMention(void);
    bool checkStatus();
    int  wait();
    int  status(void) { return statusCode; }
    char *response(void) { return httpBody; }
};

#endif  //Stewitter_H
