/*
 Stewitter.cpp - Arduino library to Post messages to Twitter with OAuth.
 Copyright (c) arms22 2010 - 2012. All right reserved.
 */
/*
 Twitter.cpp - Arduino library to Post messages to Twitter.
 Copyright (c) NeoCat 2009. All right reserved.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 */
/* Modified by 2015 phsfan
 *  for ABIT PHS Shield on mbed
 */

#include "Stewitter_a3gs.h"

#define STEWGATE_POST_API           "/api/post/"
#define STEWGATE_LAST_MENTION_API   "/api/last_mention/"
#define STEWGATE_HOST               "stewgate-u.appspot.com"

Stewitter_a3gs::Stewitter_a3gs(const char *token, A3GS &a3gs) : _a3gs(a3gs), token(token)
{
    httpBody[0] = 0;
}

bool Stewitter_a3gs::post(const char *msg)
{
    int r;
    char buf[a3gsMAX_RESULT_LENGTH + 1];
    statusCode = 0;
    parseStatus = 0;
    httpBody[0] = 0;

    int length = a3gsMAX_RESULT_LENGTH;
    char header[40], body[a3gsMAX_BODY_LENGTH];
    if (msg != NULL) {
        snprintf(body, sizeof(body), "_t=%s&msg=%s", token, msg);
        snprintf(header, sizeof(header), "Content-Length: %d", strlen(body));
        r = _a3gs.httpPOST(STEWGATE_HOST, 80, STEWGATE_POST_API, header, body, buf, &length, false);
        if (r == 0) _a3gs.read(&buf[length], sizeof(buf) - length);
    } else {
        snprintf(body, sizeof(body), "_t=%s", token);
        snprintf(header, sizeof(header), "Content-Length: %d", strlen(body));
        r = _a3gs.httpPOST(STEWGATE_HOST, 80, STEWGATE_LAST_MENTION_API, header, body, buf, &length, false);
        if (r == 0) _a3gs.read(&buf[length], sizeof(buf) - length);
    }

    if (r == 0) {
        parse(buf);
        return true;
    } else {
        return false;
    }
}

bool Stewitter_a3gs::lastMention(void)
{
    return post(NULL);
}

void Stewitter_a3gs::parse (char *buf) {
    int i, len = 0;

    for (i = 0; i < strlen(buf); i ++) {
        char c = buf[i];
//        if (debug)
//            printf("%c", c);
        switch(parseStatus) {
            case 0: // skip "HTTP/1.1 "
                if (c == ' ') {
                    parseStatus++;
                }
                break;
            case 1: // parse Status Code
                if (c >= '0' && c <= '9') { 
                    statusCode *= 10;
                    statusCode += c - '0';
                } else {
                    parseStatus++;
                }
                break;
            case 2: // skip HTTP Headers
                if (c == '\x0a') {
                    parseStatus++;
                }
                break;
            case 3:
                if (c == '\x0d') {
                    parseStatus++;
                }else{
                    parseStatus = 2;
                }
                break;
            case 4:
                if (c == '\x0a') {
                    parseStatus++;
                }else{
                    parseStatus = 2;
                }
                break;
            case 5: // recv HTTP Body
                httpBody[len] = c;
                len ++;
                break;
        }
    }
    httpBody[len] = 0;
}

bool Stewitter_a3gs::checkStatus()
{
    return false;
}

int Stewitter_a3gs::wait()
{
    while (checkStatus());
    return statusCode;
}
