#include "mbed.h"
#include "a3gs.h"
#include "TinyHTTP_a3gs.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

A3GS a3gs(p28, p27, p29, p23, p11, 9600); // tx, rx, interrupt, power, regulator

void callback (char *buf, int len) {
    buf[len] = 0;
    printf(buf);
}

int main() {
    pc.baud(115200);
    pc.printf("*** PHS Shield\r\n");

    a3gs.start();
    if (a3gs.begin()) {
        error("Could not connect");
    }
    myled = 1;

    //GET data
    printf("Trying to fetch page...\r\n");
    httpRequest(METHOD_GET, "developer.mbed.org", 80, "/media/uploads/phsfan/hello.txt", NULL, NULL, callback);
    printf("\r\n");
/*
    char buf[a3gsMAX_RESULT_LENGTH + 1];
    char header[] = "Server: developer.mbed.org\n";
    if (a3gs.httpGET("developer.mbed.org", 80, "/media/uploads/phsfan/hello.txt", buf, sizeof(buf), false, header) == 0) {
        printf("HTTP GET: %s\r\n", buf);
    }
*/
    wait(1);
    pc.printf("bye\r\n");
    a3gs.end();
    a3gs.shutdown();
    myled = 0;
}
