/*
 * mbed Tiny HTTP Client for Ethernet Interface Library
 * Copyright (c) 2012 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

/** @file
 * @brief Tiny HTTP Client
 */

#include "mbed.h"
#include "TinyHTTP_a3gs.h"
#include "a3gs.h"
#include <ctype.h>

//#define DEBUG

extern A3GS a3gs;
static onHttpReceiveFunc onHttpReceive = NULL;

// Copyright (c) 2010 Donatien Garnier (donatiengar [at] gmail [dot] com)
int base64enc(const char *input, unsigned int length, char *output, int len) {
  static const char base64[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  unsigned int c, c1, c2, c3;

  if (len < ((((length-1)/3)+1)<<2)) return -1;
  for(unsigned int i = 0, j = 0; i<length; i+=3,j+=4) {
    c1 = ((((unsigned char)*((unsigned char *)&input[i]))));
    c2 = (length>i+1)?((((unsigned char)*((unsigned char *)&input[i+1])))):0;
    c3 = (length>i+2)?((((unsigned char)*((unsigned char *)&input[i+2])))):0;

    c = ((c1 & 0xFC) >> 2);
    output[j+0] = base64[c];
    c = ((c1 & 0x03) << 4) | ((c2 & 0xF0) >> 4);
    output[j+1] = base64[c];
    c = ((c2 & 0x0F) << 2) | ((c3 & 0xC0) >> 6);
    output[j+2] = (length>i+1)?base64[c]:'=';
    c = (c3 & 0x3F);
    output[j+3] = (length>i+2)?base64[c]:'=';
  }
  output[(((length-1)/3)+1)<<2] = '\0';
  return 0;
}

// Copyright (c) 2010 Donatien Garnier (donatiengar [at] gmail [dot] com)
int urlencode(char *str, char *buf, int len) {
  static const char to_hex[] = "0123456789ABCDEF";
//  char *pstr = str, *buf = (char*)malloc(strlen(str) * 3 + 1), *pbuf = buf;
  char *pstr = str, *pbuf = buf;

  if (len < (strlen(str) * 3 + 1)) return -1;
  while (*pstr) {
    if (isalnum(*pstr) || *pstr == '-' || *pstr == '_' || *pstr == '.' || *pstr == '~') {
      *pbuf++ = *pstr;
    } else if (*pstr == ' ') {
      *pbuf++ = '+';
    } else { 
      *pbuf++ = '%';
      *pbuf++ = to_hex[(*pstr >> 4) & 0x0f];
      *pbuf++ = to_hex[*pstr & 0x0f];
    }
    pstr++;
  }
  *pbuf = '\0';
  return 0;
}

void createauth (char *user, char *pwd, char *buf, int len) {
    char tmp[80];

    strncpy(buf, "Authorization: Basic ", len);
    snprintf(tmp, sizeof(tmp), "%s:%s", user, pwd);
    base64enc(tmp, strlen(tmp), &buf[strlen(buf)], len - strlen(buf));
    strncat(buf, "\r\n", len - strlen(buf));
}

int httpRequest (int method, char *host, int port, char *uri, char *head, char *body, onHttpReceiveFunc func) {
    char buf[1000];
    int i, ret = -1;

    onHttpReceive = func;

    if (a3gs.connectTCP(host, port)) return -1;

#ifdef DEBUG
        printf("connected\r\n");
#endif

    // send request
    if (method == METHOD_POST) {
        a3gs.write((uint8_t*)"POST ", 5);
    } else {
        a3gs.write((uint8_t*)"GET ", 4);
    }
    a3gs.write((uint8_t*)uri, strlen(uri));
    a3gs.write((uint8_t*)" HTTP/1.1\r\nHost: ", 17);
    a3gs.write((uint8_t*)host, strlen(host));
    a3gs.write((uint8_t*)"\r\n", 2);
    a3gs.write((uint8_t*)"Connection: close\r\n", 19);
    if (head) {
        a3gs.write((uint8_t*)head, strlen(head));
    }
    if (method == METHOD_POST) {
        sprintf(buf, "Content-Length: %d\r\n", strlen(body));
        a3gs.write((uint8_t*)buf, strlen(buf));
    }
    a3gs.write((uint8_t*)"\r\n", 2);

    // post method
    if (method == METHOD_POST && body) {
        a3gs.write((uint8_t*)body, strlen(body));
    }

    printf("wait for response\r\n");
    // recv
    int err = 0;
    for (;;) {
        i = a3gs.read(buf, sizeof(buf) - 1);
        if (i <= 0) break;

        if (onHttpReceive != NULL) onHttpReceive(buf, i);
    }
    ret = 0;

    a3gs.disconnectTCP();

    return ret;
}
