#include "mbed.h"
#include "a3gs.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

//        tx, rx, interrupt, power, regulator
A3GS a3gs(p28, p27, p29, p23, p11, 9600); // mbeduino (LPC1768)
//A3GS a3gs(PA_11, PA_12, D2, D6, D7, 9600); // Nucleo STM32F401RE

const char *server = "developer.mbed.org";
const char *path = "/media/uploads/phsfan/hello.txt";
const char *head = "Content-Type: application/x-www-form-urlencoded";
int port = 80;

int main() {
    pc.baud(115200);
    pc.printf("*** PHS httpGET\r\n");

    a3gs.start();
    if (a3gs.begin()) {
        error("Could not connect");
    }
    myled = 1;

    char buf[a3gsMAX_RESULT_LENGTH + 1];
    if (a3gs.httpGET(server, port, path, buf, sizeof(buf) - 1, 0, head) == 0) {
        pc.printf("OK!\r\n");
        pc.printf(buf);
        for (;;) {
            int r = a3gs.read(buf, sizeof(buf) - 1);
            if (r > 0) {
                pc.printf(buf);
            } else {
                break;
            }
        }
        pc.printf("\r\n");
    } else {
        pc.printf("Can't get HTTP response from %s\r\n", server);
    }

    wait(3);
    a3gs.disconnectTCP();
    pc.printf("bye\r\n");
    a3gs.end();
    a3gs.shutdown();
    myled = 0;
}
