#include "phs_f405.h"
#include "stm32f4xx_hal.h"
#include <cstdarg>


void PhsReset::write (int value) {
    __GPIOB_CLK_ENABLE();
    if (value) {
        GPIOB->MODER &= ~(3<<22); // PB_11 input
        GPIOB->PUPDR = (GPIOB->PUPDR & ~(3<<22)) | (1<<22); // pullup
        GPIOB->OTYPER &= ~(1<<11); // push pull
        GPIOB->BSRRL = (1<<11); // reser=1
    } else {
        GPIOB->MODER = (GPIOB->MODER & ~(3<<22)) | (1<<22); // PB_11 output
        GPIOB->PUPDR &= ~(3<<22); // pull none
        GPIOB->OTYPER |= (1<<11); // open drain
        GPIOB->BSRRH = (1<<11); // reser=0
    }
}

int PhsReset::read () {
    int status;
    status = (GPIOB->ODR & (1<<11)) ? 1 : 0;
    return status;
}


#define STRING_STACK_LIMIT 256
#define UART5_BASE            (APB1PERIPH_BASE + 0x5000)
#define UART5               ((USART_TypeDef *) UART5_BASE)
#define  RCC_APB1ENR_UART5EN                 ((uint32_t)0x00100000)
#define __UART5_CLK_ENABLE()   (RCC->APB1ENR |= (RCC_APB1ENR_UART5EN))
#define GPIO_AF8_UART5         ((uint8_t)0x08) 

ShieldSerial::ShieldSerial (int baud) {
    __UART5_CLK_ENABLE();

    UartHandle.Instance = (USART_TypeDef *)UART5;
    UartHandle.Init.BaudRate   = baud;
    UartHandle.Init.WordLength = UART_WORDLENGTH_8B;
    UartHandle.Init.StopBits   = UART_STOPBITS_1;
    UartHandle.Init.Parity     = UART_PARITY_NONE;
    UartHandle.Init.HwFlowCtl  = UART_HWCONTROL_NONE;
    UartHandle.Init.Mode = UART_MODE_TX_RX;
    if (HAL_UART_Init(&UartHandle) != HAL_OK) {
        mbed_die();
    }

    __GPIOC_CLK_ENABLE();
    __GPIOD_CLK_ENABLE();
    GPIO_InitTypeDef  GPIO_InitStruct;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Speed     = GPIO_SPEED_FAST;
    GPIO_InitStruct.Pin       = GPIO_PIN_12;
    GPIO_InitStruct.Alternate = GPIO_AF8_UART5;
    HAL_GPIO_Init(GPIOC, &GPIO_InitStruct); // TX
    GPIO_InitStruct.Pin = GPIO_PIN_2;
    GPIO_InitStruct.Alternate = GPIO_AF8_UART5;
    HAL_GPIO_Init(GPIOD, &GPIO_InitStruct); // RX
}

int ShieldSerial::getc () {
    while (!readable());
    return (int)(UartHandle.Instance->DR & 0x1FF);
}

int ShieldSerial::putc (int c) {
    while (!writeable());
    UartHandle.Instance->DR = (uint32_t)(c & 0x1FF);
    return 0;
}

int ShieldSerial::readable () {
    int status;
    status = ((__HAL_UART_GET_FLAG(&UartHandle, UART_FLAG_RXNE) != RESET) ? 1 : 0);
    return status;
}

int ShieldSerial::writeable () {
    int status;
    status = ((__HAL_UART_GET_FLAG(&UartHandle, UART_FLAG_TXE) != RESET) ? 1 : 0);
    return status;
}
