#ifndef _phs_f405_h_
#define _phs_f405_h_

#include "mbed.h"

class PhsReset {
public:
    void write (int value);
    int read ();

    PhsReset& operator= (int value) {
        write(value);
        return *this;
    }

    PhsReset& operator= (PhsReset& rhs) {
        write(rhs.read());
        return *this;
    }

    operator int() {
        return read();
    }
};


class ShieldSerial {
public:
    ShieldSerial (int baud);
    int getc ();
    int putc (int c);
    int readable ();
    int writeable ();
protected:
    UART_HandleTypeDef UartHandle;
};

#endif
