/*
 * select: Nucleo F401RE
 */
#include "mbed.h"
#include "phs_f405.h"

//#define BAUD 120000
#define BAUD 9600

Serial pc(PB_6, PB_7);

ShieldSerial ser(BAUD); // PC_12, PD_2
DigitalIn pwron(PC_5), regon(PC_4);
DigitalOut state(PB_1);

Serial phs(PA_2, PA_3);
DigitalOut rts(PA_1), dsr(PA_5);
DigitalIn cts(PA_0), dcd(PA_7), dtr(PA_6), ri(PA_4);
PhsReset reset; // PB_11

DigitalOut power(PC_9);
DigitalOut led1(PC_7), led2(PC_6);

int main() {
    pwron.mode(PullUp);
    regon.mode(PullDown);
    reset = 0;
    power = 0; // DCDC on
    led1 = 0;
    led2 = 0;
    phs.baud(BAUD);
    cts.mode(PullUp);
    dsr = rts = 1;
    wait_ms(200);
 
    for (;;) {
        if (phs.readable() && ser.writeable()) {
            ser.putc(phs.getc());
        }
        if (ser.readable() && phs.writeable()) {
            phs.putc(ser.getc());
        }

        reset = pwron;
        led2 = pwron;
        dsr = rts = regon;
    }
}
