#include "mbed.h"
#include "a3gs.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

//        tx, rx, interrupt, power, regulator
A3GS a3gs(p28, p27, p29, p23, p11, 9600); // mbeduino (LPC1768)
//A3GS a3gs(PA_11, PA_12, D2, D6, D7, 9600); // Nucleo STM32F401RE

const char *server = "developer.mbed.org";
const char *path = "/media/uploads/phsfan/hello.txt";
const char *head = "Accept: text/html\r\nConnection: Keep-Alive";
int port = 80;

int main() {
    pc.baud(115200);
    pc.printf("*** PHS connectTCP\r\n");

    a3gs.start();
    if (a3gs.begin()) {
        error("Could not connect");
    }
    myled = 1;

    char buf[a3gsMAX_RESULT_LENGTH + 1];
    if (a3gs.connectTCP(server, 80) == 0) {
        pc.printf("OK!\r\n");
        sprintf(buf, "GET /%s HTTP/1.1\r\n", path);
        a3gs.write(buf);
        sprintf(buf, "Host: %s\r\n", server);
        a3gs.write(buf);
        a3gs.write("Accept: text/html; charset=ISO-8859-1\r\n");
        a3gs.write("Connection: Keep-Alive\r\n\r\n");
        for (;;) {
            int r = a3gs.read(buf, sizeof(buf) - 1);
            if (r > 0) {
                pc.printf(buf);
            } else {
                break;
            }
        }
        pc.printf("\r\n");
    } else {
        pc.printf("Can't get HTTP response from %s\r\n", server);
    }

    wait(3);
    a3gs.disconnectTCP();
    pc.printf("bye\r\n");
    a3gs.end();
    a3gs.shutdown();
    myled = 0;
}
