#include "mbed.h"
#include "a3gs.h"
#include "Stewitter_a3gs.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

A3GS a3gs(p28, p27, p29, p23, p11, 9600); // tx, rx, interrupt, power, regulator
Stewitter_a3gs twitter("YOUR TOKEN", a3gs);

const char *msg = "Hello, World! I'm mbed!"; // url encoded ASCII or UTF-8

int main() {
    pc.baud(115200);
    pc.printf("*** PHS Shield\r\n");

    a3gs.start();
    if (a3gs.begin()) {
        error("Could not connect");
    }
    myled = 1;

    if (twitter.lastMention()) {
        int status = twitter.wait();
        printf("lastMention: %d '%s'\r\n", status, twitter.response());
    }

    if (twitter.post(msg)) {
        int status = twitter.wait();
        printf("post: %d '%s'\r\n", status, twitter.response());
    }

    wait(1);
    pc.printf("bye\r\n");
    a3gs.end();
    a3gs.shutdown();
    myled = 0;
}
