/*
 * select: Nucleo F401RE
 */
#include "mbed.h"

Serial pc(PB_6, PB_7);

Serial phs(PA_2, PA_3);
DigitalOut rts(PA_1);
DigitalIn cts(PA_0);

DigitalOut led1(PC_6), led2(PC_7);
DigitalOut pwr1(PC_9);
DigitalIn pwr2(PA_8);


int main() {
    pc.baud(115200);
    phs.baud(120000);
    pwr1 = 0; // DCDC enable
    pwr2.mode(PullUp);
    GPIOB->MODER = (GPIOB->MODER & ~(3<<22)) | (1<<22); // PB_11 output
    GPIOB->OTYPER = (1<<11); // open drain
    GPIOB->ODR &= ~(1<<11); // reser=0
//    phs.set_flow_control(Serial::RTSCTS, PA_1, PA_0);
    cts.mode(PullUp);
    rts = 0;
    wait_ms(100);
    GPIOB->MODER &= ~(3<<22); // PB_11 input
    GPIOB->PUPDR = (GPIOB->MODER & ~(3<<22)) | (1<<22); // pullup

    pc.printf("*** PHSShield STM32F405\r\n");    

    for (;;) {
        if (phs.readable()) {
            pc.putc(phs.getc());
        }
        if (pc.readable()) {
            phs.putc(pc.getc());
        }
        led2 = cts;
    }
}
