// http://developer.mbed.org/users/donatien/code/VodafoneUSBModemWebsocketTest/
#include "mbed.h"
#include "AbitUSBModem.h"
#include "Websocket.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

void test(void const*) 
{
    AbitUSBModem modem;
    Websocket ws("ws://sockets.mbed.org:443/ws/username/demo/rw");
    char recv[128];

    printf("connect\r\n");
    int ret = modem.connect("prin", "prin");
    if(ret) {
      printf("Could not connect\r\n");
      return;
    }

    printf("IP Address %s\r\n", modem.getIPAddress());

    bool c = ws.connect();
    printf("Connect result: %s\r\n", c?"OK":"Failed");
    
    for(int i = 0; i < 10000; i++)
    {
        if(!(i%100))
        {
          int ret = ws.send("WebSocket Hello World over the Y!mobile Network!");
          if(ret<0)
          {
            printf("Timeout\r\n");
            ws.close();
            c = ws.connect();
            printf("Connect result: %s\r\n", c?"OK":"Failed");
          }
        }
        
        if (ws.read(recv)) {
            printf("rcv: %s\r\n", recv);
        }
    }

    Thread::wait(1000);
    printf("exit\r\n");
    modem.disconnect();  
}

int main()
{
    pc.baud(115200); 
    printf("** PHS MQTT\r\n");

    Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
    while(1) {
        myled = !myled;
        Thread::wait(1000);  
    }
}
