#include "mbed.h"
#include "AbitUSBModem.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

void test(void const*) 
{
    AbitUSBModem modem;

    modem.sendSM("07012345678", "Hello mbed");

    while(1) {
        char num[17];
        char msg[64];

        int ret = modem.getSM(num, msg, 64);
        if (!ret) {
          printf("SMS from: %s, message: %s\r\n", num, msg);
        }
    
        Thread::wait(3000);
    }
}

int main()
{
    pc.baud(115200); 
    printf("** PHS\r\n");

    Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
    while(1) {
        myled = !myled;
        Thread::wait(1000);  
    }
}
