// https://developer.mbed.org/teams/mqtt/code/HelloMQTT
#include "mbed.h"
#include "AbitUSBModem.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

#include "MQTTAbitUSBModem.h"
#include "MQTTClient.h"

int arrivedcount = 0;

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\r\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;
//    printf((char*)message.payload);
}

void test(void const*) 
{
    MQTTAbitUSBModem ipstack = MQTTAbitUSBModem();
    float version = 0.47;
    char* topic = "mbed-sample";

    AbitUSBModem &modem = ipstack.getModem();
    printf("IP Address %s\r\n", modem.getIPAddress());

    printf("Version is %f\r\n", version);

    MQTT::Client<MQTTAbitUSBModem, Countdown> client = MQTT::Client<MQTTAbitUSBModem, Countdown>(ipstack);

    char* hostname = "m2m.eclipse.org";
    int port = 1883;
    printf("Connecting to %s:%d\r\n", hostname, port);
    int rc = ipstack.connect(hostname, port);
    if (rc != 0)
        printf("rc from TCP connect is %d\r\n", rc);

    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
    data.MQTTVersion = 3;
    data.clientID.cstring = "mbed-sample";
    data.username.cstring = "testuser";
    data.password.cstring = "testpassword";
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\r\n", rc);

    if ((rc = client.subscribe(topic, MQTT::QOS1, messageArrived)) != 0)
        printf("rc from MQTT subscribe is %d\r\n", rc);

    MQTT::Message message;

    // QoS 0
    char buf[100];
    sprintf(buf, "Hello World!  QoS 0 message from app version %f\r\n", version);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topic, message);
    while (arrivedcount < 1)
        client.yield(100);

    // QoS 1
    sprintf(buf, "Hello World!  QoS 1 message from app version %f\r\n", version);
    message.qos = MQTT::QOS1;
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topic, message);
    while (arrivedcount < 2)
        client.yield(100);

#if MQTTCLIENT_QOS2
    // QoS 2
    sprintf(buf, "Hello World!  QoS 2 message from app version %f\r\n", version);
    message.qos = MQTT::QOS2;
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topic, message);
    while (arrivedcount < 3)
        client.yield(100);

    // n * QoS 2
    for (int i = 1; i <= 10; ++i)
    {
        sprintf(buf, "Hello World!  QoS 2 message number %d from app version %f\r\n", i, version);
        message.qos = MQTT::QOS2;
        message.payloadlen = strlen(buf)+1;
        rc = client.publish(topic, message);
        while (arrivedcount < i + 3)
            client.yield(100);
    }
#endif

    if ((rc = client.unsubscribe(topic)) != 0)
        printf("rc from unsubscribe was %d\r\n", rc);

    if ((rc = client.disconnect()) != 0)
        printf("rc from disconnect was %d\r\n", rc);

    ipstack.disconnect();

    Thread::wait(1000);
    printf("exit\r\n");
    modem.disconnect();  
}

int main()
{
    pc.baud(115200); 
    printf("** PHS MQTT\r\n");

    Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
    while(1) {
        myled = !myled;
        Thread::wait(1000);  
    }
}
